/* Roy Keene
   CS 2314
   Section 04
   Lab 07
   22 Oct 02
   sortedtype.h
*/


// This file contains the definition of the SortedType class. This class
// uses a binary search tree as its container and provides functions
// for inserting, deleting, and retreiving items.  Functions for
// printing the items in the tree, emptying the tree, and discovering
// the number of items in the tree are also provided.
// 
// This is modified from Dale and Teague's C++ plus Data Structures
// second edition, pp 672-73

#ifndef SORTED_TYPE_H
#define SORTED_TYPE_H

#include <iostream>
#include <fstream>
#include <stack>

template<class ItemType>

/* Assumption: 
	ItemType is a type for which the operators "<", "==", and "<<"
	are defined--either an appropriate built-in type or a class that overloads
	these operators
*/
class SortedType {
	public:
		// Class constructor and destructor
		SortedType(void);
		~SortedType(void);

		// Initializes the tree to an empty state
		void MakeEmpty(void);

		// Determines the number of elemens
		// returns this number
		int LengthIs(void) const;


		// All of the following operations have the pre/post
		// condition that the items are sorted

		// Retrieves  element whose key matches item's key (if present)
		// If there is an element, someItem, whose key matches item's key, then
		// this function returns true and item is a copy of someItem; otherwise
		// this function returns false, and item is unchanged.
		// The tree is unchanged by this operation
		bool RetrieveItem(ItemType &item);

		// Add item to the tree if the item is not already in the tree
		void InsertItem(ItemType item);

		// Deletes the element whose key matches item's key
		void DeleteItem(ItemType item);

		// Prints the items in ascending order to outFile
		void PrintList(ofstream& outFile);

	private:
		struct BinTree_Node {
			ItemType data;
			struct BinTree_Node *left;
			struct BinTree_Node *right;
#ifdef _CS2314_LAB7_DUPLICATES
			unsigned int cnt;
#endif
		};
		struct BinTree_Node *TreeHead;
};


template<class ItemType> SortedType<ItemType>::SortedType(void) {
	TreeHead=NULL;
	return;
}

template<class ItemType> SortedType<ItemType>::~SortedType(void) {
	MakeEmpty();
	return;
}

template<class ItemType> void SortedType<ItemType>::MakeEmpty(void) {
	static struct BinTree_Node *currNode=TreeHead;
	struct BinTree_Node *parent;
	static int level=0;

	if (level==0) currNode=TreeHead;
	if (currNode==NULL) return;

	level++;
	if (currNode->left!=NULL) {
		parent=currNode;
		currNode=currNode->left;
		MakeEmpty();
		currNode=parent;
		currNode->left=NULL;
	} 
	if (currNode->right!=NULL) {
		parent=currNode;
		currNode=currNode->right;
		MakeEmpty();
		currNode=parent;
		currNode->right=NULL;
	}
	delete currNode;

	level--;
	if (level==0) TreeHead=NULL;
	return;
}

template<class ItemType> int SortedType<ItemType>::LengthIs(void) const {
	static struct BinTree_Node *currNode=TreeHead;
	struct BinTree_Node *parent;
	static int level=0, cnt=0;

	if (level==0) { currNode=TreeHead; cnt=0; }
	if (currNode==NULL) return(cnt);

#ifdef _CS2314_LAB7_DUPLICATES
	cnt+=currNode->cnt;
#else
	cnt++;
#endif
	level++;
	if (currNode->left!=NULL) {
		parent=currNode;
		currNode=currNode->left;
		LengthIs();
		currNode=parent;
	} 
	if (currNode->right!=NULL) {
		parent=currNode;
		currNode=currNode->right;
		LengthIs();
		currNode=parent;
	}

	level--;
	return(cnt);
}


template<class ItemType> void SortedType<ItemType>::DeleteItem(ItemType item) {
	struct BinTree_Node *currNode=TreeHead, *parent=NULL, *tmp;

	if (currNode==NULL) return;
	while (1) {
		if ( item < (currNode->data) ) {
			if (currNode->left==NULL) { break; }
			parent=currNode;
			currNode=currNode->left;
		} else {
			if (currNode->data==item) {
#ifdef _CS2314_LAB7_DUPLICATES
				currNode->cnt--;
				if (currNode->cnt) break;
#endif
				if (currNode->left) { tmp=currNode->left; } else { tmp=currNode->right; }
				if (parent) {
					if (item<(parent->data)) {
						parent->left=tmp;
					} else {
						parent->right=tmp;
					}
				} else {
					TreeHead=tmp;
				}
				if (tmp!=currNode->right) {
					while (tmp) {
						if (!tmp->right) break;
						tmp=tmp->right;
					}
					tmp->right=currNode->right;
				}
				delete currNode;
				break;
			}
			if (currNode->right==NULL) { break; }
			parent=currNode;
			currNode=currNode->right;
		}
	}

	return;
}

template<class ItemType> void SortedType<ItemType>::PrintList(ofstream& outFile) {
	static struct BinTree_Node *currNode=TreeHead;
	struct BinTree_Node *parent;
	static int level=0;
#ifdef _CS2314_LAB7_DUPLICATES
	unsigned int i;
#endif

	if (level==0) currNode=TreeHead;
	if (currNode==NULL) return;

	level++;
	if (currNode->left!=NULL) {
		parent=currNode;
		currNode=currNode->left;
		PrintList(outFile);
		currNode=parent;
	} 
#ifdef _CS2314_LAB7_DUPLICATES
	for (i=0;i<currNode->cnt;i++)
#endif
		outFile << currNode->data << "::";
	if (currNode->right!=NULL) {
		parent=currNode;
		currNode=currNode->right;
		PrintList(outFile);
		currNode=parent;
	}

	level--;
	if (level==0) outFile << "\n";
	return;
}


template<class ItemType> bool SortedType<ItemType>::RetrieveItem(ItemType &item) {
	struct BinTree_Node *currNode=TreeHead;
	bool ret=false;

	if (currNode==NULL) return(ret);
	while (1) {
		if ( item < (currNode->data) ) {
			if (currNode->left==NULL) { break; }
			currNode=currNode->left;
		} else {
			if (currNode->data==item) { ret=true; break; }
			if (currNode->right==NULL) { break; }
			currNode=currNode->right;
		}
	}

	return(ret);
}

template<class ItemType> void SortedType<ItemType>::InsertItem(ItemType item) {
	struct BinTree_Node *newNode=new struct BinTree_Node, *currNode=TreeHead;

	newNode->data=item;
	newNode->left=NULL;
	newNode->right=NULL;
#ifdef _CS2314_LAB7_DUPLICATES
	newNode->cnt=1;
#endif

	if (currNode==NULL) { TreeHead=newNode; return; }
	while (1) {
		if ( item < (currNode->data) ) {
			if (currNode->left==NULL) { currNode->left=newNode; break; }
			currNode=currNode->left;
		} else {
			if (currNode->data==item) {
#ifdef _CS2314_LAB7_DUPLICATES
				currNode->cnt++;
				delete newNode;
#else
				/* Do something?! */
#endif
				break;
			}
			if (currNode->right==NULL) { currNode->right=newNode; break; }
			currNode=currNode->right;
		}
	}
	return;
}


#endif
