/* Roy Keene
   CS 2314
   Section 04
   Lab 04
   17 Sept 02
   queue.h

*/


using namespace std;

// File Queue.h: Header file for Queue ADT.  
// Class is templated.

template <typename ItemType>
class QueType {
	public:
		// Class constructor.
		// Because there is a default constructor, the precondition that the queue
		// has been initialized is omitted.
		QueType(void);
		// Class destructor.
		~QueType(void);
		// Function: Initializes the queue to an empty state.
		// Post: Queue is empty.
		void MakeEmpty(void);
		// Function: Determines whether the queue is empty.
		// Post: Function value = (queue is empty)
		bool IsEmpty(void) const;
		// Function: Determines whether the queue is full.
		// Post: Function value = (queue is full)
		bool IsFull(void) const;
		// Function: Adds newItem to the rear of the queue.
		// Pre:  Queue is not full.
		// Post: newItem is at the rear of the queue.
		void Enqueue(const ItemType &newItem);
		// Function: Removes front item from the queue.
		// Pre:  Queue is not empty.
		// Post: Front element has been removed from the queue.
		void Dequeue(void);
		// Function: Return the front item on the queue
		// Pre: Queue is not empty.
		// Post: Queue is unchanged, item is returned
		ItemType & Front(void) const;
		// Function: Return the next item in the list
		// Pre: Queue is not empty.
		// Post: Queue is unchanged, item is returned
		ItemType & Next(int reset) const;
	private:
		class NodeType {
			public:	
				ItemType info;
				NodeType* next;
		};    
		NodeType* qFront;
		NodeType* qRear;
};



template <typename ItemType> QueType<ItemType>::QueType(void) {
	qFront=NULL;
	qRear=NULL;
}

template <typename ItemType> void QueType<ItemType>::MakeEmpty(void) {
	NodeType *tmp;
	while (qFront) {
		tmp=qFront->next;
		delete qFront;
		qFront=tmp;
	}
	qRear=NULL;
}

template <typename ItemType> QueType<ItemType>::~QueType(void) {
	MakeEmpty();
}


template <typename ItemType> bool QueType<ItemType>::IsEmpty(void) const {
	return(qFront==NULL);
}

template <typename ItemType> bool QueType<ItemType>::IsFull(void) const {
	return(false);
}

template <typename ItemType> void QueType<ItemType>::Enqueue(const ItemType &newItem) {
	NodeType *newNode=new NodeType;

	if (IsFull()) return;
	newNode->info=newItem;
	newNode->next=NULL;
	if (qRear!=NULL) qRear->next=newNode;
	qRear=newNode;
	if (qFront==NULL) qFront=qRear;

	return;
}

template <typename ItemType> void QueType<ItemType>::Dequeue(void) {
	NodeType *tmp;

	if (IsEmpty()) return;
	tmp=qFront->next;
	delete qFront;
	qFront=tmp;
	if (qFront==NULL) qRear=NULL;

	return;
}

template <typename ItemType> ItemType &QueType<ItemType>::Front(void) const {
/* XXX: Need to throw an exception here if IsEmpty() ! */
	return(qFront->info);
}
template <typename ItemType> ItemType &QueType<ItemType>::Next(int reset) const {
/* XXX: Need to throw an exception here if IsEmpty() ! */
	static NodeType *nodeptr=qFront;
	static ItemType tmp;

	if (reset || nodeptr==NULL) { nodeptr=qFront; return(nodeptr->info); }
	tmp=nodeptr->info;
	nodeptr=nodeptr->next;
	return(tmp);
}
