/* Roy Keene
   CS 2314
   Section 04
   Lab 04
   17 Sept 02
   queue.cpp

   Fully tested configurations:
        *MSVC++       6.0    i386    Windows XP
        *Sun Workshop 6.0    sun4u   Solaris
        *pgCC         4.0-2  i386    Linux
        *g++          3.0.3  sun4u   Solaris
        *g++          3.0.2  ip27    IRIX
        *g++          2.95.4 i386    FreeBSD
        *g++          2.95.4 alpha   Linux
        *g++          2.95.4 sun4u   Linux
        *g++          2.95.4 powerpc Linux
        *g++          2.95.3 i386    Linux
        *g++          2.95.3 sun4u   Solaris
        *c++          2.95.2 powerpc MacOS X
        *g++          2.8.1  sun4u   Solaris
*/

#include <cstdlib>
#include <iostream>

using namespace std;
#include "queue.h"

template <typename ItemType> QueType<ItemType>::QueType(void) {
	qFront=NULL;
	qRear=NULL;
}

template <typename ItemType> void QueType<ItemType>::MakeEmpty(void) {
	NodeType *tmp;
	while (qFront) {
		tmp=qFront->next;
		delete qFront;
		qFront=tmp;
	}
	qRear=NULL;
}

template <typename ItemType> QueType<ItemType>::~QueType(void) {
}


template <typename ItemType> bool QueType<ItemType>::IsEmpty(void) const {
	return(qFront==NULL);
}

template <typename ItemType> bool QueType<ItemType>::IsFull(void) const {
	return(false);
}

template <typename ItemType> void QueType<ItemType>::Enqueue(const ItemType &newItem) {
	NodeType *newNode=new NodeType;

	newNode->next=qFront;
	newNode->info=newItem;
	qFront=newNode;
	if (qRear==NULL) qRear=qFront;

	return;
}

template <typename ItemType> void QueType<ItemType>::Dequeue(void) {
	NodeType *tmp;

	tmp=qFront->next;
	delete qFront;
	qFront=tmp;
	if (qFront==NULL) qRear=NULL;

	return;
}

template <typename ItemType> ItemType &QueType<ItemType>::Front(void) const {
	return(qFront->info);
}
