/* Roy Keene
   CS 2314
   Section 04
   Lab 10
   12 Nov 02
   heap.h
*/

#include <vector>

using namespace std;

#ifdef DEBUG
#define PrintHeap(x) cout << x ":Heap: "; for (unsigned int i=0;i<HeapData.size();i++) cout << HeapData[i] << ","; cout << "\n"
#else
#define PrintHeap(x) /**/
#endif

template <typename HeapType> class Heap {
	public:
		Heap(void);
		~Heap(void);

		bool empty(void);
		int size(void);
		void push(HeapType item);
		void insert(HeapType item);  // This has O(1) but breaks the heap;
		void heapify(void);
		HeapType top(void);
		void pop(void);
	private:
		void percolateDown(int node);
		void percolateUp(int node);
		bool IsHeap;
		vector<HeapType> HeapData;
};

template <typename HeapType> Heap<HeapType>::Heap(void) {
	IsHeap=true;
	return;
}

template <typename HeapType> Heap<HeapType>::~Heap(void) {
	return;
}

template <typename HeapType> bool Heap<HeapType>::empty(void) {
	return(HeapData.size()==0);
}

template <typename HeapType> int Heap<HeapType>::size(void) {
	return(HeapData.size());
}

template <typename HeapType> void Heap<HeapType>::push(HeapType item) {
	HeapData.push_back(item);
	percolateUp(HeapData.size()-1);
	return;
}

template <typename HeapType> void Heap<HeapType>::insert(HeapType item) {
	HeapData.push_back(item);
	IsHeap=false;
	return;
}

template <typename HeapType> void Heap<HeapType>::heapify(void) {
	int i, lidx, ridx, midx, size;

	if (IsHeap) return;

	PrintHeap("heapify1");
	size=HeapData.size();
	for (i=((size-1)/2);i>=0;i--) {
		midx=lidx=(2*i)+1;
		ridx=(2*i)+2;
		if (midx>=size) continue;
		if (ridx<size) {
			if (HeapData[ridx]>HeapData[lidx]) midx=ridx;
		}
		if (HeapData[midx]>HeapData[i]) {
			percolateDown(i);
		}
	}
	IsHeap=true;
	PrintHeap("heapify2");
	return;
}

template <typename HeapType> HeapType Heap<HeapType>::top(void) {
	heapify(); // NOTE: heapify()  returns immediately if IsHeap is set.

	return(HeapData.front());
}

template <typename HeapType> void Heap<HeapType>::pop(void) {
	PrintHeap("pop1");
	HeapData[0]=HeapData[HeapData.size()-1];
	HeapData.pop_back();
	percolateDown(0);
	PrintHeap("pop2");
	return;
}

template <typename HeapType> void Heap<HeapType>::percolateDown(int node) {
	int i=node, lidx, ridx, midx, size;
	HeapType tmp;

	PrintHeap("percdown");
	while (1) {
		if (i>=(size=HeapData.size())) break;
		midx=lidx=(2*i)+1;
		ridx=(2*i)+2;
		if (lidx>=size) break;
		if (ridx<size) {
			if (HeapData[ridx]>HeapData[lidx]) midx=ridx;
		}
		if (HeapData[midx]>HeapData[i]) {
			tmp=HeapData[i];
			HeapData[i]=HeapData[midx];
			HeapData[midx]=tmp;
		} else {
			if (IsHeap) break;
		}
		i=midx;
	}
	return;
}

template <typename HeapType> void Heap<HeapType>::percolateUp(int node) {
	int i=node, pidx;
	HeapType tmp;

	PrintHeap("percdown");

	while (1) {
		pidx=((i-1)/2);
#if 0
		if (!IsHeap) {
// XXX: Should we do some L/R comparisons here ?			
		}
#endif
		if (HeapData[i]>HeapData[pidx]) {
			tmp=HeapData[i];
			HeapData[i]=HeapData[pidx];
			HeapData[pidx]=tmp;
		} else {
			if (IsHeap) break;
		}

		if (pidx==0) break;
		i=pidx;
	}
	return;
}
