#! /bin/bash

# Define parameters
VERS=1.6
SRC="src/tls${VERS}-src.tar.gz"
SRCURL="http://sourceforge.net/projects/tls/files/tls/${VERS}/tls${VERS}-src.tar.gz/download"
BUILDDIR="tls${VERS}"
PATCHDIR="$(pwd)/patches"
export VERS SRC SRCURL BUILDDIR PATCHDIR

# Load common functions
source ../common.sh

# Do not build if the "tcl" platform has been requested
not_platforms 'tcl'

# Download source
download_src

# Extract source
extract_src

# Apply appropriate patches
apply_patches

(
	cd "build/${BUILDDIR}" || exit 1

	if [ -z "${SSLDIR}" ]; then
		for chkssldir in $(pkg-config openssl --cflags | sed 's@ *-I *@|@g' | tr '|' "\n" | grep '^/'); do
			if [ -f "${chkssldir}/openssl/opensslv.h" -o -f "${chkssldir}/opensslv.h" ]; then
				SSLDIR=$(echo "${chkssldir}" | sed 's@/[^/]*/*$@@')
			fi
		done
	fi
	if [ -z "${SSLDIR}" ]; then
		SSLDIR="/usr"
	fi

	bash ./configure --enable-shared --with-tcl="${TCLCONFIGDIR}" --with-ssl-dir="${SSLDIR}" ${CONFIGUREEXTRA}
	${MAKE:-make} || exit 1
) || exit 1

(
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null

	cp "build/${BUILDDIR}/libtls1.6.so" "${PLATDIR}/"
	cp "build/${BUILDDIR}/pkgIndex.tcl" "${PLATDIR}/"
	cp "build/${BUILDDIR}/tls.tcl" "${PLATDIR}/"

	../create_teapot "${PLATDIR}/teapot.txt" "tls" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.4" "SSL TLS Secure Sockets"
) || exit 1

exit 0
