#! /bin/bash

# Define parameters
VERS=0.8.3
SRC="src/tDOM-${VERS}.tgz"
SRCURL="https://github.com/downloads/tDOM/tdom/tDOM-${VERS}.tgz"
BUILDDIR="tDOM-${VERS}"
export VERS SRC SRCURL BUILDDIR

# Load common functions
source ../common.sh

# Do not build if the "tcl" platform has been requested
not_platforms 'tcl'

# Download source
download_src

# Build package
(
	rm -rf build
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null
	mkdir build

	cd build/ || exit 1

	gzip -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	bash ./configure --enable-shared --enable-threads --with-tcl="${TCLCONFIGDIR}" --prefix="${PLATDIR}" --libdir="${PLATDIR}" --bindir="${PLATDIR}" ${CONFIGUREEXTRA}

	${MAKE:-make} || exit 1

	${MAKE:-make} install-binaries PKG_DIR='' || exit 1

	rm -f "${PLATDIR}"/*.a
	rm -f "${PLATDIR}"/tdomConfig.sh
) || exit 1

# Create metadata
../create_teapot "${PLATDIR}/teapot.txt" "tdom" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.4" "tDOM combines high performance XML data processing with easy and powerful Tcl scripting functionality. tDOM should be one of the fastest ways to manipulate XML with a scripting language and uses very little memory in the process.  http://tdom.github.com/"

exit 0
