#! /bin/bash

# Define parameters
VERS=0.9.9
SRC="src/tclpkcs11-${VERS}.tar.gz"
SRCURL="http://www.rkeene.org/devel/tclpkcs11-${VERS}.tar.gz"
BUILDDIR="tclpkcs11-${VERS}"
export VERS SRC SRCURL BUILDDIR

# Load common functions
source ../common.sh

# Do not build if the "tcl" platform has been requested
not_platforms 'tcl'

# Download source
download_src

(
	rm -rf build
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null
	mkdir build

	cd build/ || exit 1

	gzip -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	./configure --enable-shared --with-tcl="${TCLCONFIGDIR}" ${CONFIGUREEXTRA}

	${MAKE:-make} || exit 1

	cp tclpkcs11.so tclpkcs11.sl tclpkcs11.dylib tclpkcs11.dll "${PLATDIR}" >/dev/null 2>/dev/null
	cp pkgIndex.tcl "${PLATDIR}"
) || exit 1

../create_teapot "${PLATDIR}/teapot.txt" "tclpkcs11" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.4, pki" "TclPKCS11 is a package to provide PKCS#11 cryptography support to Tcl.  This will let you offload cryptographic operations onto a dedicated hardware or software module."

exit 0
