#! /bin/bash

VERS=1.13
SRC="src/tcllib-${VERS}.tar.gz"
SRCURL="http://sourceforge.net/projects/tcllib/files/tcllib/${VERS}/tcllib-${VERS}.tar.gz/download"
BUILDDIR="tcllib-${VERS}"
export VERS SRC SRCURL BUILDDIR

# Load common functions
source ../common.sh

# Do not build if the "tcl" platform has NOT been requested
only_platforms 'tcl'

# Download source
download_src

rm -rf "${WORKDIR}" >/dev/null 2>/dev/null
mkdir -p "${WORKDIR}" || exit 1

retval=0
(
	rm -rf build
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null
	mkdir build

	cd build/ || exit 1

	gzip -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	find modules -type f -name '*.test' -o -name 'ChangeLog' -o -name '*.man' -o -name '*.txt' | xargs rm -f

	workfile="${WORKDIR}/file"
	worksubfile="${WORKDIR}/subfile"
	pkgfiles=""
	for file in modules/*/*.tcl; do
		cat "${file}" | tr ';[]{}' "\n\n\n\n\n" | sed 's@^[	 ]*#.*$@@' "${file}" > "${workfile}"

		if grep '^ *package  *provide  *' "${workfile}" >/dev/null; then
			pkgfiles="${pkgfiles}
${file}"
		fi
	done

	for file in modules/*/*.tcl; do
		filetail="$(basename "${file}")"
		if [ "${filetail}" = "pkgIndex.tcl" ]; then
			continue
		fi

		pkgdir="$(dirname "${file}")"

		cat "${file}" | tr ';[]{}	' "\n\n\n\n\n " | sed 's@^ *#.*$@@' > "${workfile}"

		# Some packages try to require a package, if that doesn't work they implement it and say they provide it (lies)
		# We remove any "package provide blah" in a file also containing "package require blah"
		# TODO: We should add "blah" to the recommended packages if we ended up removing anything
		grep '^ *package  *require  *' "${workfile}" | while read blah blah reqpkg remain; do
			grep -v "^ *package  *provide  *${reqpkg}  *" "${workfile}" > "${workfile}.new"
			mv "${workfile}.new" "${workfile}"
		done

		if ! grep '^ *package  *provide  *[^ ][^ ]*  *[^ ][^ ]*' "${workfile}" >/dev/null; then
			continue
		fi

		# Determine package name and version
		pkg="$(grep '^ *package  *provide  *[^ ][^ ]*  *[^ ][^ ]*' "${workfile}" | head -1 | sed 's@^ *package  *provide  *\([^ ][^ ]*\) .*$@\1@' | sed 's@^  *@@;s@  *$@@')"
		pkgver="$(grep '^ *package  *provide  *[^ ][^ ]*  *[^ ][^ ]*' "${workfile}" | head -1 | sed 's@^ *package  *provide  *[^ ][^ ]*  *\([^ ][^ ]*\)*$@\1@;s@^[^0-9\.].*@@g')"

		if echo "${pkg}" | grep '^ *\[' >/dev/null || [ -z "${pkg}" ]; then
			pkg="$(grep "package  *ifneeded  *" "${pkgdir}/pkgIndex.tcl" | sed 's@^.*package  *ifneeded  *\([^ ][^ ]*\) .*$@\1@' | sed 's@^  *@@;s@  *$@@')"
			if [ "$(echo "${pkg}" | wc -l | awk '{ print $1 }')" != "1" ]; then
				pkg="$(basename "${file}" .tcl)"

				echo "Unable to determine name of package: $file, assuming it is $pkg"
			fi
		fi
		if [ -z "${pkgver}" ]; then
			pkgver="$(grep "package  *ifneeded  *.*source  *.* ${filetail}" "${pkgdir}/pkgIndex.tcl" 2>/dev/null | sed 's@^.*package  *ifneeded  *[^ ][^ ]*  *\([^ ][^ ]*\) .*$@\1@' | head -1)"
		fi
		if [ -z "${pkgver}" ]; then
			pkgver="$(grep "package  *ifneeded  *${pkg}  *" "${pkgdir}/pkgIndex.tcl" 2>/dev/null | sed 's@^.*package  *ifneeded  *[^ ][^ ]*  *\([^ ][^ ]*\) .*$@\1@' | head -1)"
		fi
		if [ -z "${pkgver}" ]; then
			echo "Unable to determine version of ${pkg}: $(grep '^ *package  *provide  *' "${workfile}" | head -1), skipping."

			continue
		fi

		# Skip marker package names
		if [ "${pkg}" = "@@" ]; then
			continue
		fi

		# Create output directory
		outdir="${PLATDIR}/${pkg}-${pkgver}"
		if [ -d "${outdir}" ]; then
			echo "ERROR: $outdir already exists, skipping ${file} which provides ${pkg} v${pkgver}"

			continue
		fi
		mkdir -p "${outdir}" || continue

		# Put relevant files into the directory
		if grep '^ *source  *' "${workfile}" >/dev/null; then
			# Include all the files in the directory that do not contain packages
			cp "${file}" "${outdir}"
			for subfile in "${pkgdir}"/*; do
				if ! echo "${pkgfiles}" | grep "^${subfile}$" >/dev/null; then
					cp "${subfile}" "${outdir}" >/dev/null 2>/dev/null
				fi
			done
			grep -v "package  *ifneeded  *" "${pkgdir}/pkgIndex.tcl" > "${outdir}/pkgIndex.tcl"
			grep "package  *ifneeded  *${pkg}  *" "${pkgdir}/pkgIndex.tcl" >> "${outdir}/pkgIndex.tcl"

			# Create Teapot info
			pkgdesc="Part of the Tclib $(basename $(dirname ${file})) module"
			pkgteapotfile="${outdir}/teapot.txt"
		else
			# Make a tclModule
			cp "${file}" "${outdir}/"
			outfile="${outdir}/${filetail}"

			# Create Teapot info
			pkgdesc="Part of the Tclib $(basename $(dirname ${file})) module"
			pkgteapotfile="${outfile}"
		fi

		pkgdeps=$( ( for subfile in "${outdir}"/*.tcl; do
			cat "${subfile}" | grep -v 'catch ' | tr ';[]{}	' "\n\n\n\n\n " | sed 's@^ *#.*$@@' > "${worksubfile}"
			grep '^ *package  *require  *' "${worksubfile}" | while read blah blah reqpkg reqpkgver extra; do
				reqpkgver="$(echo "${reqpkgver}" | sed 's@ *\$.*$@@')"
				if [ -n "${reqpkgver}" ]; then
					reqpkgver=$(echo "${reqpkgver}" | sed 's@[+=-]*$@@g')
					echo "${reqpkg} ${reqpkgver}"
				else
					echo "${reqpkg}"
				fi
			done | sort -u | grep -v '__undefined__' | grep -v '__does_not_exist__'
		done | tr "\n" ','; echo ) | sed 's@,,*$@@')

		../../../create_teapot "${pkgteapotfile}" "$pkg" "$pkgver" "http://tcllib.sourceforge.net/" "tcl" "${pkgdeps}" "${pkgdesc}"
	done
) || retval=1

rm -rf "${WORKDIR}"

exit $retval
