#! /bin/bash

# Define parameters
VERS=3.7.2
VERSUNDER="$(echo "${VERS}" | sed 's@\.@_@g')"
SRC="src/sqlite-${VERSUNDER}.tar.gz"
SRCURL="http://www.sqlite.org/sqlite-${VERSUNDER}-tea.tar.gz"
BUILDDIR="sqlite${VERS}"
export VERS SRC SRCURL BUILDDIR

# Load common functions
source ../common.sh

# Do not build if the "tcl" platform has been requested
not_platforms 'tcl'

# Download source
download_src

(
	rm -rf build
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null
	mkdir build

	cd build/ || exit 1

	gzip -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	chmod +x tclconfig/install-sh

	bash ./configure --enable-shared --with-tcl="${TCLCONFIGDIR}" --prefix="${PLATDIR}" --libdir="${PLATDIR}" --bindir="${PLATDIR}" ${CONFIGUREEXTRA}

	${MAKE:-make} || exit 1

	${MAKE:-make} install-binaries PKG_DIR='' || exit 1

	rm -f "${PLATDIR}"/*.a
) || exit 1

../create_teapot "${PLATDIR}/teapot.txt" "sqlite3" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.4" "SQLite"

exit 0
