#! /bin/bash

# Define parameters
VERS=8.5.2
SRC="src/tclDict-${VERS}.tar.gz"
SRCURL="http://pascal.scheffers.net/software/tclDict-${VERS}.tar.gz"
BUILDDIR="tclDict-${VERS}"
export VERS SRC SRCURL BUILDDIR

# Load common functions
source ../common.sh

# Do not build if the "tcl" platform has been requested
not_platforms 'tcl'

# Require Tcl 8.4 to build
setup_tcl84

# Download source
download_src

(
	rm -rf build
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null
	mkdir build

	cd build/ || exit 1

	gzip -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	# This fixes a well-known, long-standing failure in many Tcl
	# configure scripts
	sed "s@ /etc/\\.relid'@ '/etc/.relid'@" configure > configure.new
	cat configure.new > configure
	rm -f configure.new

	bash ./configure --enable-shared --with-tcl="${TCLCONFIGDIR}" --prefix="${PLATDIR}" --libdir="${PLATDIR}" --bindir="${PLATDIR}" ${CONFIGUREEXTRA}

	${MAKE:-make} || exit 1

	${MAKE:-make} install-binaries PKG_DIR='' || exit 1

	rm -f "${PLATDIR}"/*.a
) || exit 1

../create_teapot "${PLATDIR}/teapot.txt" "dict" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.4" "Dict Backports for Tcl 8.4"

exit 0
