#! /bin/bash

# Define parameters
VERS=1.0
SRC="src/dbus-tcl-${VERS}.tar.gz"
SRCURL="http://sourceforge.net/projects/dbus-tcl/files/dbus-tcl/${VERS}/dbus-tcl${VERS}.tar.gz/download"
BUILDDIR="dbus-tcl${VERS}"
export VERS SRC SRCURL BUILDDIR

# Load common functions
source ../common.sh

# Do not build if the "tcl" platform has been requested
not_platforms 'tcl'

# Require Tcl 8.5 to build
setup_tcl85

# Download source
download_src

# Build package
(
	rm -rf build
	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null
	mkdir build

	cd build/ || exit 1

	gzip -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	bash ./configure --enable-shared --with-tcl="${TCLCONFIGDIR}" --prefix="${PLATDIR}" --libdir="${PLATDIR}" --bindir="${PLATDIR}" ${CONFIGUREEXTRA}

	${MAKE:-make} || exit 1

	${MAKE:-make} install-binaries PKG_DIR='' || exit 1

	rm -f "${PLATDIR}"/*.a
	mv "${PLATDIR}"/dbus-tcl/* "${PLATDIR}"/
	rm -rf "${PLATDIR}"/dbus-tcl
) || exit 1

# Create metadata
../create_teapot "${PLATDIR}/teapot.txt" "dbus-tcl" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.5" "The DBus-Tcl project provides a Tcl interface to the dbus message bus system. It contains packages that allow Tcl programs to send and receive dbus signals, as well as invoke and respond to dbus method calls.  http://dbus-tcl.sourceforge.net/"

exit 0
