#! /bin/bash

if [ ! -x "../platform" ]; then
	echo "No platform script found, aborting." >&2

	exit 1
fi

if [ "${PLATFORM}" = "tcl" ]; then
	rm -rf out

	exit 0
fi

VERS=8.4
SRC="src/tclx${VERS}.tar.bz2"
SRCURL="http://sourceforge.net/projects/tclx/files/TclX/${VERS}.0/tclx${VERS}.tar.bz2/download"
BUILDDIR="tclx${VERS}"
WORKDIR="${TMPDIR:-/tmp}/tclx-$$${RANDOM}${RANDOM}${RANDOM}"
PLATDIR="$(pwd)/out/${PLATFORM}"

export VERS SRC SRCURL BUILDDIR WORKDIR PLATDIR

(
	rm -rf build
	mkdir build
) || exit 1

if [ ! -f "${SRC}" ]; then
	mkdir src >/dev/null 2>/dev/null

	wget -O "${SRC}" "${SRCURL}" || exit 1
fi

(
	cd build/ || exit 1

	bzip2 -dc "../${SRC}" | tar -xf -
	cd "${BUILDDIR}" || exit 1

	cat << \__EOF__ | patch -p1
--- tclx8.4/configure.relid	2006-02-03 16:13:25.000000000 -0500
+++ tclx8.4/configure	2006-02-03 16:13:33.000000000 -0500
@@ -6999,7 +6999,7 @@
 	    # results, and the version is kept in special file).
 
 	    if test -r /etc/.relid -a "X`uname -n`" = "X`uname -s`" ; then
-		system=MP-RAS-`awk '{print }' /etc/.relid'`
+		system=MP-RAS-`awk '{print }' /etc/.relid`
 	    fi
 	    if test "`uname -s`" = "AIX" ; then
 		system=AIX-`uname -v`.`uname -r`
--- tclx8.4/tclconfig/tcl.m4.relid	2006-02-03 16:13:43.000000000 -0500
+++ tclx8.4/tclconfig/tcl.m4	2006-02-03 16:13:57.000000000 -0500
@@ -859,7 +859,7 @@
 	    # results, and the version is kept in special file).
 	
 	    if test -r /etc/.relid -a "X`uname -n`" = "X`uname -s`" ; then
-		system=MP-RAS-`awk '{print $3}' /etc/.relid'`
+		system=MP-RAS-`awk '{print $3}' /etc/.relid`
 	    fi
 	    if test "`uname -s`" = "AIX" ; then
 		system=AIX-`uname -v`.`uname -r`
@@ -2302,7 +2302,7 @@
 	    # results, and the version is kept in special file).
 	
 	    if test -r /etc/.relid -a "X`uname -n`" = "X`uname -s`" ; then
-		system=MP-RAS-`awk '{print $3}' /etc/.relid'`
+		system=MP-RAS-`awk '{print $3}' /etc/.relid`
 	    fi
 	    if test "`uname -s`" = "AIX" ; then
 		system=AIX-`uname -v`.`uname -r`
__EOF__
	cat << \__EOF__ | patch -p1
--- tclx8.4/generic/tclXdup.c.varinit	2006-02-03 15:54:38.000000000 -0500
+++ tclx8.4/generic/tclXdup.c	2006-02-03 15:54:53.000000000 -0500
@@ -202,7 +202,7 @@
 {
     Tcl_Channel newChannel;
     int bindFnum, fnum;
-    char *srcChannelId, *targetChannelId;
+    char *srcChannelId = NULL, *targetChannelId;
 
     if ((objc < 2) || (objc > 3)) {
         return TclX_WrongArgs (interp, objv [0],
__EOF__


	bash ./configure --enable-shared --with-tcl="${TCLCONFIGDIR}" --libdir="${PLATDIR}" ${CONFIGUREEXTRA}
	${MAKE:-make} || exit 1

	mkdir -p "${PLATDIR}" >/dev/null 2>/dev/null

	${MAKE:-make} install-lib-binaries PKG_DIR='' || exit 1

) || exit 1

../create_teapot "${PLATDIR}/teapot.txt" "Tclx" "${VERS}" "${SRCURL}" "${PLATFORM}" "Tcl 8.4" "Extended Tcl"

exit 0
