.de XI
\\$1
.BI \\$2 \\$3
\\$4
..
.de HB
The
.B -hex
and
.B -binary
options determine the formatting of the result.
..
.de XN
The
.B -xrb
option causes all parsed addresses to be prefixed with the old-style "xrb_" address prefix, while the
.B -nano
option causes them to be prefixed with the new-style "nano_prefix".
..
.de JB
If the optional
.B -json
argument is used and specified as true the result is a JSON representation,
otherwise a Tcl dict representation is used.
..
.de RR
The
.I representation
portion of the command name may be one of
.B dict
or
.BR json .
..
.TH NANO N "08-Dec-2018" "nano 1.2"
.SH NAME
nano \- Tcl bindings for Nano
.SH SYNOPSIS

.B nano::
.in +2m
.B address::
.in +2m
.B toPublicKey
.I address
.RB ? -hex | -binary ?
.RB ? -verify | -no-verify ?
.br
.B fromPublicKey
.I pubKey
.RB ? -xrb | -nano ?
.br
.B fromPrivateKey
.I privateKey
.RB ? -xrb | -nano ?

.in -2m
.B key::
.in +2m
.B newSeed
.RB ? -hex | -binary ?
.br
.B newKey
.RB ? -hex | -binary ?
.br
.B fromSeed
.I seed
.RI ? index ?
.RB ? -hex | -binary ?
.br
.B publicKeyFromPrivateKey
.I privateKey
.RB ? -hex | -binary ?

.in -2m
.B block::
.in +2m
.B json::toBlock
.I blockJSON
.br
.B json::fromDict
.I blockDict
.br
.B json::fromBlock
.I blockData
.RB ? -xrb | -nano ?
.XI ? -type= blockType ?
.XI ? -signKey= privateKey ?
.br
.B json::sign
.I blockJSON
.I privateKey
.RB ? -update | -signature " ?" -hex | binary ??
.br
.B json::verifySignature
.I blockJSON
.br
.B json::work
.I blockJSON
.RB ? -update | -work " ?" -hex | -binary ??
.br
.B json::validateWork
.I blockJSON
.br
.B json::filter
.I blockJSON

.B dict::toBlock
.I blockDict
.br
.B dict::fromJSON
.I blockJSON
.br
.B dict::fromBlock
.I blockData
.RB ? -xrb | -nano ?
.XI ? -type= blockType ?
.XI ? -signKey= privateKey ?
.br
.B dict::sign
.I blockDict
.I privateKey
.RB ? -update | -signature " ?" -hex | binary ??
.br
.B dict::verifySignature
.I blockDict
.br
.B dict::work
.I blockDict
.RB ? -update | -work " ?" -hex | -binary ??
.br
.B dict::validateWork
.I blockDict

.B hash
.I blockData
.RB ? -hex | -binary ?
.br
.B signBlockHash
.I blockHash
.I privateKey
.RB ? -hex | -binary ?
.br
.B sign
.I blockData
.I privateKey
.RB ? -hex | -binary ?
.br
.B verifyBlockHash
.I blockHash
.I signature
.I publicKey
.br
.B verify
.I blockData
.I signature
.I publicKey

.B create::send
.I args
.br
.B create::receive
.I args
.br
.B create::setRepresentative
.I args

.in -2m
.B work::
.in +2m
.B fromWorkData
.I blockHashOrPublicKey
.RB ? -hex | -binary ?
.br
.B fromBlock
.I blockData
.br
.B validate
.I workData
.I work

.in -2m
.B account::
.in +2m
.B setFrontier
.I account
.I frontierHash
.I balance
.I representative
.br
.B getFrontier
.I account
.br
.B getFrontier
.I account
.RB ? frontierHash | balance | representative ?
.br
.B addPending
.I account
.I blockHash
.I amount
.br
.B getPending
.I account
.RI ? blockHash ?
.br
.B clearPending
.I account
.RI ? blockHash ?

.B receive
.I account
.I blockHash
.I privateKey
.br
.B receiveAllPending
.I account
.I privateKey
.br
.B send
.I fromAccount
.I toAccount
.I amount
.I privateKey
.br
.B setRepresentative
.I account
.I representative
.I privateKey

.in -2m
.in -2m

.SH INTRODUCTION
.I Nano
is a low-latency payment platform that requires minimal resources, relying on
a peer-to-peer network to distribute "blocks", which are cryptographically
signed transactions.  This package provides bindings for interacting with the
Nano network from
.IR Tcl .

Nano uses Ed25519 with Blake2b as the cryptographic hashing primitive for
digital signatures, rather than the common construction of Ed25519 with the
SHA2-512 cryptographic hashing function.

Nano implements a "blockchain", which is a cryptographic linked-list, by
identifying every "block" by its cryptographic hash and providing a pointer from
every block to its predecessor in the "chain" as part of the hashed data.

This predecessors is referred to here as the "previous" block.  In Nano,
each account has its own blockchain and they reference each other using a
data structure referred to as "block lattice", where the individual chains
contain blocks that reference blocks in other chains to tie them together.
The field within blocks that reference other blocks on a different blockchain
is referred to as either the "link" field or "source block hash".

Each Nano block also encapsulates the full state of the account, containing,
at a minimum, a tuple of
.RI ( account ", " balance ", " representative ", " previous ).

Since Nano blocks are signed by independent actors, who may, for their own gain,
generate multiple valid blocks referring to the same predecessor
.RI ( previous )
block, an arbitration mechanism is employed by the Nano network to decide which
blocks are valid within a given chain.  This arbitration mechanism operates on
the principles of consensus.  Each account holder has a stake in the network
operating nominally, otherwise the balance represented by an account is not
useful for a transfer of value.  In Nano the stake an account has in the
network is equal to the account's balance.  The larger the stake an account has
the more incentivized the account-holder is to ensure the network is operating
nominally and not accepting multiple blocks that reference the same
predecessor.

Nano utilizes a mechanism called
.I voting
to determine which blocks are valid and which blocks are not valid.  Each
stakeholder votes their stake upon seeing a new subordinate block
.RI ( i.e. ,
a block with a unique
.I previous
value).  Since voting is an active and on-going process that occurs on the Nano
peer-to-peer network, participants must be online to vote their stake.  As this
is often inconvenient or impossible, stakeholders may select another
stakeholder to vote their share of the network.  This delegate is referred to
as a
.IR representative .

Representatives should be chosen carefully by stakeholders since malicious
representatives may attempt to gather voting power and destabilize the Nano
network by altering decisions made by consensus previously.

Nano accounts are referred to by address.  A Nano address starts with the
prefix
.RB \(dq nano_ "\(dq or \(dq" xrb_ \(dq.
A Nano address is actually the public portion of a private/public keypair,
plus the prefix, and a checksum to ensure that no digits are mistyped by
users when communicating them.  Nano public keys are 256-bit keys in the
Ed25519 algorithm.

A user may have many accounts.  To simplify the process of maintaining the
private/public keypairs for all the accounts, Nano supports the concept of a
.IR wallet .
A
.I wallet
is a conceptual entity that is used to refer to a
.IR seed ,
which is a random 256-bit number that can be used to derive multiple
private/public keypairs from.

Balances in Nano are stored in a 128-bit integer value.  There are various
units for representing the balance, the smallest and base unit is called
.RI \(dq raw \(dq.
The most common unit for users to use is called
.RI \(dq Nano \(dq,
one of which is equal to 1e30 raw.

.SS Addresses
Nano addresses are composed of a prefix (either
.RB \(dq nano_ \(dq
or
.RB \(dq xrb_ \(dq)
and 300 bits of base32 encoded data.  The 300-bits of base32 encoded data
produce a string that is 60 characters long using the base32 alphabet
.BR 13456789abcdefghijkmnopqrstuwxyz .
The format of these 300 bits are
.EX

   struct {
       uint4_t padding = 0000b;
       uint256_t publicKey;
       uint40_t  checksum;
   }

.EE
The checksum is computed as a 5 byte (40 bit) Blake2b hash of the 256-bit
public key (in binary format), followed by reversing the bytes.

For example the public key
.B DC1512154EB72112B8CC230D7B8C7DD467DA78E4763182D6CAFAADB14855A5E8
which has a 5-byte Blake2b hash of
.B {0x18, 0x74, 0xA3, 0x46, 0x9C}
would be encoded as
.B 0000.DC1512154EB72112B8CC230D7B8C7DD467DA78E4763182D6CAFAADB14855A5E8.9C46A37418
which when encoded in base32 and the prefix added produces the address
.BR nano_3q1o4acnxfs34cwerarfhg89uo59ubwgaxjjiddeoyofp767dbhamj5c8x1r .

.SS Network
The Nano network consists of two different peer-to-peer networks.  One for
real-time block updates over UDP, and another for bulk ledger updates over
TCP
.RI ( bootstrapping ).
The real-time network is a broadcast style network where every message sent
over it are relayed to all other nodes.

The customary and default port for the real-time/UDP network is 7075/udp, while
the default port for the bootstrapping/TCP network is 7075/tcp.

The format of the messages on both networks is the same, however not every
type of message may be used on either network.  The
.B keepalive
message type is invalid on the TCP (bootstrapping) network and the
.B bulk_pull
message type is invalid on the UDP (real-time) network.  The format of
message are an 8 byte header consisting of:
.EX

   struct {
       uint8_t magicProtocol = 0x52;
       uint8_t magicNetwork  = 0x41/0x42/0x43;
       uint8_t versionMax;
       uint8_t version;
       uint8_t versionMin;
       uint8_t messageType;
       uint16_t extensions;
   };

.EE
Where the
.B magicProtocol
field must be the value
.B 0x52
(which is ASCII 'R') and the
.B magicNetwork
field must be one of
.BR 0x41 ", " 0x42 ", or " 0x43
corresponding to one of the three Nano networks.  A value of
.B 0x41
(ASCII 'A') represents the Test network;  A value of
.B 0x42
(ASCII 'B') represents the Beta network;  A value of
.B 0x43
(ASCII 'C') represents the Main network.

The various version fields control the relaying of the message to nodes running
various versions of the Nano network protocol (distinct from the Nano reference
implementation version).  The
.B versionMax
and
.B versionMin
fields indicate the inclusive range of acceptable versions to relay or broadcast
this message to.  The
.B version
field indicates what version of the Nano protocol this node is using.

The messageType field indicates what type of message is being relayed, and
must conform to the following enumeration
.TS
allbox tab(:);
cb cb cb cb cb
c l l l c.
messageType:Name:On Bootstrap:On Realtime:Version
0x00:Invalid:Yes:Yes:1+
0x01:Not_A_Type:Yes:Yes:1+
0x02:Keepalive:No:Yes:1+
0x03:Publish:No:Yes:1+
0x04:Confirm_Req:No:Yes:1+
0x05:Confirm_Ack:No:Yes:1+
0x06:Bulk_Pull:Yes:No:1+
0x07:Bulk_Push:Yes:No:1+
0x08:Frontier_Req:Yes:No:1+
0x09:Bulk_Pull_Blocks:Yes:No:Deprecated
0x0A:Node_ID_Handshake:Yes:No:12+
0x0B:Bulk_Pull_Account:Yes:No:12+
.TE

.TP
.B Extensions
The following message types have extension bits used as flags:
.IR Node_ID_Handshake ", " Bulk_Pull .

The following message types encode a block type in the extension bits:
.IR Publish ", " Confirm_Req ", and " Confirm_Ack .
The block type is encoded in the lower 4 bits of the first byte of the
extensions field (i.e., (extensions & 0x0f00 >> 8)).

.SS Payload
Following the message header comes the payload for the particular message
type.

.TP
.B Invalid
TODOC

.TP
.B Not_A_Type
TODOC

.TP
.B Keepalive
The
.I Keepalive
message serves as an introduction and beaconing mechanism for
the Nano real-time network.
The Keepalive message requires exactly 8 IPv6 address and port number
tuples to be sent as its payload.  The IPv6 addresses are each 128-bits
(16-bytes) long and the port numbers are 16-bit integers sent in little endian
byte order.  The payload for the Keepalive message type is 144 bytes in size.

.TP
.B Publish
The
.I Publish
message serves as a mechanism to introduce new blocks into the
Nano real-time network.  The block type is encoded in the
.I Extensions
field as described above.  The payload is the contents of the block.

.TP
.B Confirm_Req
The
.I Confirm_Req
message requests that all online representatives "vote" on a block.
The block type is encoded in the
.I Extensions
field as described above.  The payload is the contents of the block
to be voted on.

.TP
.B Confirm_Ack
The
.I Confirm_Ack
message is sent in response to either a new block being observed
by a representative or in response to an explicit
.IR Confirm_Req .
The block type is encoded in the
.I Extensions
field as described above.
If the block type is specified as
.I Not_A_Block
then the payload is a sequence of hashes.  Due to IPv4 fragment
size limits this typically does not exceed 12 hashes.  If the
block type is something other than
.I Not_A_Block
then the payload is the contents of the block that is being
voted on.

.TP
.B Bulk_Pull
The Bulk_Pull message is used to pull the entire chain for an account, down to
its beginning or to a given block.  It takes 2 or 3 arguments.  The first two
arguments are  256-bits each.  The first argument is the account, so its
256-bit public key should be encoded as binary in big-endian notation.  The
second argument is the block hash to stop sending at, or 256 bits of 0s to
indicate that the entire chain should be sent.  If the
.I Extensions
field has the lowest bit set
.RI ( Count_Present )
then an additional 8 bytes of data are present in the payload.  The first byte
of these 8 bytes must be 0, followed by a 4 byte (32-bit) unsigned integer in
little endian format that contains the maximum number of records to return.  The
remaining 3 bytes in the payload are reserved at this time.
The payload for
.I Bulk_Pull
messages is 64 bytes (if the 
.I Count_Present
flag is not set) or 72 bytes (if the
.I Count_Present
flag is set) in size.

The response from a Bulk_Pull request will be a stream of tuples, each
containing a 8-bit block type identifier, and a block message.  When no more
blocks are available the response is terminated by sending the block type
identifier for
.I not_a_block
and no block message follows.


.TP
.B Bulk_Push
TODOC

.TP
.B Frontier_Req
The Frontier_Req message is used to pull a list of accounts from a remote node
for the purpose of bootstrapping.  It requires 3 arguments:  The 256-bit
public key of an account to start with, a 32-bit integer denoting the age of
accounts to return, and a 32-bit integer denoting the number of records to
return.  If the
.I age
parameter is
.B 0xffffffff
then all records are returned, regardless of age.  If the
.I count
parameter is
.B 0xffffffff
then all records are returned and no limit is imposed.

The response from a Frontier_Req is a 256-bit public key, and the 256-bit
block hash that corresponds to the frontier (most recent block) for that
account's blockchain from the node where the response was generated.

.TP
.B Bulk_Pull_Blocks
Deprecated.  Do not use.

.TP
.B Node_ID_Handshake
TODOC

.TP
.B Bulk_Pull_Account
The
.I Bulk_Pull_Account
message is used to pull information regarding an account, such as its
frontier, current balance, and any blocks that are pending for that account.
It requires 3 arguments:  The 256-bit account public key, a 128-bit minimum
amount to for which to return pending blocks for, and an 8 bit flags.

.SH PROCEDURES
.SS Addresses
.TP
.B ::nano::address::toPublicKey
.I address
.RB ? -hex | -binary ?
.RB ? -verify | -no-verify ?
.BI " -> " publicKey

Converts a Nano address to a public key.  The
.B -hex
option indicates that the public key should be returned in hexadecimal form.
The
.B -binary
option indicates that the public key should be returned in binary form.
The
.B -verify
option verifies the checksum embedded in the Nano address before returning.
The
.B -no-verify
option inhibits verifying the checksum embedded in the Nano address.

.TP
.B ::nano::address::fromPublicKey
.I pubKey
.RB ? -xrb | -nano ?
.BI " -> " address

Converts a public key to a Nano address. The
.B -xrb
option specifies that the returned address should be prefixed with the
old-style "xrb_" prefix, where the
.B -nano
option specifies that the returned address should be prefixed with the
new-style "nano_" prefix.

.TP
.B ::nano::address::fromPrivateKey
.I privateKey
.RB ? -xrb | -nano ?
.BI " -> " address

Converts a private key to a Nano address.  It accepts the same arguments as
.BR fromPublicKey .

.SS Key Management
.TP
.B ::nano::key::newSeed
.RB ? -hex | -binary ?
.RI "-> " seed

Generates a new seed.  A seed is a 256-bit bit-field which, along with a 32-bit
index, is used to derive enumerated keys from a single point of entropy.  See
the
.B fromSeed
procedure.
.HB

.TP
.B ::nano::key::newKey
.RB ? -hex | -binary ?
.RI " -> " privateKey

Generates a new private key.  A private key can be used to sign transactions,
which can then be verified with its corresponding public key (see
.BR publicKeyFromPrivateKey ).
This procedure is normally not used, but rather private keys are derived
from a
.I seed
and
.I index
pair using the
.B fromSeed
procedure.
.HB

.TP
.B ::nano::key::fromSeed
.I seed
.RI ? index ?
.RB ? -hex | -binary ?
.RI " -> " privateKey

Derive a private key from the seed specified as
.I seed
and the
.I index
indicated.  This procedure is deterministic (i.e., the same
.I seed
and
.I index
will always give you the same private key).  This procedure is used to derive
many keypairs from a single user-managed piece of data, so the user does not
have to manage multiple private keys.  If the
.I index
is not specified it defaults to
.BR 0 .
.HB

.TP
.B ::nano::key::publicKeyFromPrivateKey
.I privateKey
.RB ? -hex | -binary ?
.RI " -> " publicKey

Converts a private key into its corresponding public key.  Normally Ed25519
private keys are a concatenation of the private and public keys, however in
this package they are each treated separately.
.HB

.SS Low-level Block
.TP
.BI ::nano::block:: representation ::toBlock
.I blockRepresentation
.RI " -> " blockData

Converts from one of the internal representations (either Tcl dictionary or JSON) to a Nano block.
.RR

.TP
.B ::nano::block::json::fromDict
.I blockDict
.RI " -> " blockJSON

Converts from a Tcl dictionary representation to a JSON representation of a block.

.TP
.B ::nano::block::json::filter
.I blockJSON
.RI " -> " blockJSON

Filters out JSON object attributes which are not suitable for using with other
implementations, such as
.IR _comment ", " _workData ", and " _blockHash .

.TP
.B ::nano::block::dict::fromJSON
.I blockJSON
.RI " -> " blockDict

Converts from a JSON object representation to a Tcl dictionary representation of a block.

.TP
.BI ::nano::block:: representation ::fromBlock
.I blockData
.RB ? -xrb | -nano ?
.XI ? -type= blockType ?
.XI ? -signKey= privateKey ?
.RI " -> " blockRepresentation

Parses a Nano block and returns either a Tcl dictionary or a JSON object.
.XN
.RR

.TP
.BI ::nano::block:: representation ::sign
.I blockRepresentation
.I privateKey
.RB ? -update | -signature " ?" -hex | binary ??
.RI " -> " signature | blockJSON

Sign a block, in either Tcl dictionary or JSON representation, with the specified
.IR privateKey .
If the
.B -update
option is used, return the object with the updated attribute.
If the
.B -signature
option is used, return just the signature.
.HB
.RR

.TP
.BI ::nano::block:: representation ::verifySignature
.I blockRepresentation
.RI " -> " boolean

Verify the signature on a block, in either Tcl dictionary or JSON
representation, matches the public key specified in the
.B account
attribute of that object.  This may not work correctly for old-style blocks
unless you manually add the
.B account
attribute.
.RR

.TP
.BI ::nano::block:: representation ::work
.I blockRepresentation
.RB ? -update | -work " ?" -hex | binary ??
.RI " -> " work | blockRepresentation

Generate proof-of-work (PoW) required to submit a given block to the network.
Nano uses PoW to increase the cost of submitting blocks to the network to cut
down on spam.  The
.I work
that is computed is based on the hash of the previous block on this chain, or
if there is no previous block on this chain (i.e., because it is the first
block on an account) the public key of the account.  If the
.B -update
option is used, return the object with the updated attribute.
If the
.B -work
option is used, just return the work.
.HB
.RR

.TP
.BI ::nano::block:: representation ::validateWork
.I blockRepresentation
.RI " -> " boolean

Validate the proof-of-work (PoW) in the object specified as
.I blockRepresentation
with the attribute
.B work
is valid for the block passed in.
.RR

.TP
.B ::nano::block::signBlockHash
.I blockHash
.I privateKey
.RB ? -hex | -binary ?
.RI " -> " signature

Compute an Ed25519-with-Blake2b signature of a given block hash specified as
.I blockHash
with the private key specified as
.IR privateKey .
In Nano, signed blocks are signed by signing the block's hash thus all that is
needed to sign a block is its hash and the private key that corresponds to the
account.
.B NOTE:  Ensure that the
.I privateKey
.B specified matches the account the block belongs to.
.HB

.TP
.B ::nano::block::verifyBlockHash
.I blockHash
.I signature
.I publicKey
.RI " -> " boolean

Verify that a block hash
.RI ( blockHash )
was signed
.RI ( signature )
by an account holding the private key that
corresponds to the public key specified as
.IR publicKey .

.TP
.B ::nano::block::create::send
.BI "from "            address
.BI "to "              address
.BI "previous "        blockHash
.BI "representative "  address
.BI "previousBalance " integer
.BI "amount "          integer
?
.BI "-json "           boolean
?
.RI " -> " blockJSON | blockDict

This is a low-level interface for creating blocks which correspond to sending
Nano from one account to another.  It constructs a block which sends the
.B amount
specified from the
.B from
address to the destination
.RB ( to ).
The previous block's hash must be specified as the
.I blockHash
following
.BR previous .
Additionally the balance of the account at the previous block must be supplied
as the integer argument to
.BR previousBalance .
All balance amounts are in units of
.BR raw .
.JB

.TP
.B ::nano::block::create::receive
.BI "to "              address
.BI "sourceBlock "     blockHash
.BI "previous "        blockHash
.BI "representative "  address
.BI "previousBalance " integer
.BI "amount "          integer
?
.BI "-json "           boolean
?
.RI " -> " blockJSON | blockDict

This is a low-level interface for creating blocks which correspond to receiving
(pocketing) Nano previously sent from another account to the account specified
as the
.I address
supplied to the
.B to
argument.  It constructs a block which receives the amount of Nano specified
as the
.B amount
argument.
The block hash
.RI ( blockHash )
of the send block which was used to send the Nano to this account must be
specified as the argument to the
.B sourceBlock
option.
The previous block's hash must be specified as the
.I blockHash
following
.BR previous .
Additionally the balance of the account at the previous block must be supplied
as the integer argument to
.BR previousBalance .
All balance amounts are in units of
.BR raw .
.JB

.TP
.B ::nano::block::create::setRepresentative
.BI "account "         address
.BI "previous "        blockHash
.BI "representative "  address
?
.BI "-json "           boolean
?
.RI " -> " blockJSON | blockDict

This is a low-level interface for creating blocks which correspond to an
explicit change of representative.  Representatives in Nano are used as
part of the Delegated Proof-of-Stake (dPoS) consensus mechanism which is
used by the Nano network to determine which block (if any) out of many possible
subordinate blocks in a chain are valid.  So that every account holder does
not have to be online to vote for valid transactions, an account may delegate
another account to vote its stake on its behalf.  That delegate is called
a representative.  An account may change its representative at any time by
issuing a block with a new representative, such as a send or receive block,
or by issuing an explicit change of representative block.  This procedure
creates an explicit change of representative block for the
.B account
specified.  It changes to the delegate to the
.B representative
specified.  Further, the
.I blockHash
of the previous block must be specified as the argument to
.BR previous .
.JB

.SS Work Generation
.TP
.B ::nano::work::fromWorkData
.I blockHashOrPublicKey
.RB ? -hex | -binary ?
.RI " -> " work

Create proof-of-work (PoW) from a block hash or public key.  Which one is used
depends on whether or not there are any other blocks in this account's chain.
If this is the first block in this account's chain then the public key of the
account is used, otherwise the hash of the blocks predecessor
.RI ( previous )
is used.  The specific value needed should be accessible from the
.B _workData
member of a JSON object or Tcl dictionary.  Note that this attribute (and all
attributes that begin with an underscore) should be discarded when
sending the block outside of the Tcl process.
.HB

.TP
.B ::nano::work::fromBlock
.I blockData
.RI " -> " work

This is a convenience procedure which computes work data (either a block hash
or a public key) for a given block and then calls
.BR fromWorkData .

.TP
.B ::nano::work::validate
.I workData
.I work
.RI " -> " boolean

This procedure validates that the supplied
.I work
is valid for the supplied
.IR workData ,
which is either a block hash or an account public key.  For more information
see the description of
.BR fromWorkData .


.SS High-level Account
.TP
.B :nano::account::setFrontier
.I account
.I frontierHash
.I balance
.I representative

This procedure is used as part of the High-level Account interface.  It sets the
.IR frontier ,
which is the block hash
.RI ( frontierHash )
and data
.RI ( balance ", " representative )
associated with that block that corresponds to the head of an account's chain.

.TP
.B :nano::account::getFrontier
.I account
.RI " -> " frontierInfo

This procedure is used as part of the High-level Account interface.  It gets
the Tcl dictionary associated with the frontier most recently set for the
specified
.IR account .

.TP
.B :nano::account::getFrontier
.I account
.RB ? frontierHash | balance | representative ?
.RI " -> " frontierHash | balance | representative

This procedure is used as part of the High-level Account interface.  It gets
a specific item from Tcl dictionary associated with the frontier most recently
set for the specified
.IR account .

.TP
.B :nano::account::addPending
.I account
.I blockHash
.I amount

This procedure is used as part of the High-level Account interface.  It is
used to indicate than a given
.I account
has a
.B receive
block that they could create.  The block hash of the corresponding
.B send
block should be supplied as the
.I blockHash
parameter.  The amount of Nano that was sent in the
.B send
block should be specified as the
.I amount
parameter (in units of raw).

.TP
.B :nano::account::getPending
.I account
.RI ? blockHash ?
.RI " -> " dict

This procedure is used as part of the High-level Account interface.  It is
used to retrieve information stored by
.B addPending
for a given
.IR account .
If the
.I blockHash
parameter is supplied then a Tcl dictionary is returned with a key called
.B amount
which contains the amount stored previously.  If the
.I blockHash
parameter is not supplied then a Tcl dictionary is returned with keys
corresponding to each block hash pending for the specified
.IR account ,
and containing a subordinate Tcl dictionary with a key called
.B amount
as previously described.

.TP
.B ::nano::account::clearPending
.I account
.RI ? blockHash ?

This procedure is used as part of the High-level Account interface.  It is
used to clear (that is, remove from the conceptual state of "pending") entries
created previously with
.B addPending
for a given
.IR account .
If the
.I blockHash
parameter is supplied then only the entry corresponding to that blockhash is
cleared, otherwise all entries for the specified
.I account
are cleared.

.TP
.B :nano::account::receive
.I account
.I blockHash
.I privateKey
.RI " -> " blockJSON | blockDict

This procedure is used as part of the High-level Account interface.  It is
used to generate a receive block.  Its interface is subject to change and
not considered stable.

.TP
.B :nano::account::receiveAllPending
.I account
.I privateKey
.RI " -> " listOfBlockJSON | listOfBlockDict

This procedure is used as part of the High-level Account interface.  It is
used to generate receive blocks for every pending receive on a given
.IR account .
Its interface is subject to change and not considered stable.

.TP
.B :nano::account::send
.I fromAccount
.I toAccount
.I amount
.I privateKey
.RI " -> " blockJSON | blockDict

This procedure is used as part of the High-level Account interface.  It is
used to generate a send block.  Its interface is subject to change and
not considered stable.

.TP
.B ::nano::account::setRepresentative
.I account
.I representative
.I privateKey
.RI " -> " blockJSON | blockDict

This procedure is used as part of the High-level Account interface.  It is
used to generate a block that changes the representative for the given
.IR account .
Its interface is subject to change and not considered stable.

.SH EXAMPLES
.SS Example 1: Generate a new seed and derive 10 addresses from it
.EX
package require nano 1.2

set seed [::nano::key::newSeed -hex]
puts "Generated seed: $seed"

for {set index 0} {$index < 10} {incr index} {
	set accountPrivateKey [::nano::key::fromSeed $seed $index -hex]
	set accountAddress [::nano::address::fromPrivateKey $accountPrivateKey]
	puts "    - $index: $accountAddress"
}
.EE

.SH AUTHOR
Roy Keene
.RI < rkeene@nano.org >
