#ifndef RSK_COMMON_H_18Nov03
#define RSK_COMMON_H_18Nov03

#include <stdio.h>

#define TASK001_VERSION "0.0.1"

#ifdef DEBUG
#define PRINTLINE fprintf(stderr, __FILE__ ":%i:%s(): ", __LINE__, __func__);
#define DPRINTERR(x...) { PRINTLINE; fprintf(stderr, x); fprintf(stderr, "\n"); }
#define DPERROR(x) { PRINTLINE; perror(x); }
#else
#define PRINTLINE fprintf(stderr, "task001: ");
#define DPRINTERR(x...) /**/
#define DPERROR(x) /**/
#endif
#define PRINTERR(x...) { PRINTLINE; fprintf(stderr, x); fprintf(stderr, "\n"); }
#define PERROR(x) { PRINTLINE; perror(x); }
#define SPOTVAR_S(x) DPRINTERR(#x " = \"%s\"", x)
#define SPOTVAR_I(x) DPRINTERR(#x " = %i", x)
#define SPOTVAR_X(x) DPRINTERR(#x " = 0x%x", x)
#define SPOTVAR_P(x) DPRINTERR(#x " = %p", x)
#define SPOTVAR(x,y) DPRINTERR(#y " = %" #x, y)
#define CHECKPOINT DPRINTERR("*** CHECKPOINT REACHED ***");

#endif
