#include <sys/time.h>
#include <inttypes.h>
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>

#define GEN_RAND_VERBOSE

uint32_t ms_to_run(const char *pathname) {
	struct timeval start, finish;
	uint32_t ret;

	gettimeofday(&start, NULL);
	system(pathname);
	gettimeofday(&finish, NULL);

	if (finish.tv_usec < start.tv_usec) {
		ret = finish.tv_usec + 1000000 - start.tv_usec;
	} else {
		ret = finish.tv_usec - start.tv_usec;
	}
	
	return(ret);
}

int generate_random_values(unsigned char *destarray, int destarray_len, int freq) {
	uint32_t x;
	unsigned char val;
	int i;

	printf("Generating random seed.\n");
	for (i = 0; i < destarray_len; i++) {
		if ((i % freq) == 0) {
			x = ms_to_run("/bin/true");
			srand((x << 14) + rand());
#ifdef GEN_RAND_VERBOSE
			printf(".");
			fflush(stdout);
#endif
		}

		if (destarray) {
			val = (int) (256.0 * rand() / (RAND_MAX + 1.0));
			destarray[i] = val;
		}
	}
#ifdef GEN_RAND_VERBOSE
	printf("\n");
#endif

	return(0);
}

int main(int argc, char **argv) {
	FILE *fp;
	unsigned char buf[1024 * 4];
	char *file = "/etc/random-seed";
	int ret;

	ret = generate_random_values(buf, sizeof(buf), 3);
	if (ret < 0) {
		printf("Error generating random numbers, aborting.\n");
		return(EXIT_FAILURE);
	}

	if (argc >= 2) {
		file = argv[1];
	}

	fp = fopen(file, "w");
	if (!fp) {
		printf("Error while opening output file: %s\n", file);
		return(EXIT_FAILURE);
	}
	fwrite(buf, sizeof(buf), sizeof(buf[0]), fp);
	fclose(fp);

	return(EXIT_SUCCESS);
}
