#ifndef TCPCGI_H
#define TCPCGI_H
#include <stdlib.h>
#include <unistd.h>
#include <stdio.h>

#ifndef TCPCGI_DAEMON_PORT
#define TCPCGI_DAEMON_PORT 9114
#endif

#ifndef TCPCGI_CLIENT_PORT
#define TCPCGI_CLIENT_PORT 9111
#endif

#ifndef TCPCGI_CLIENT_POLLTIME_MIN
#define TCPCGI_CLIENT_POLLTIME_MIN 200
#endif

#ifndef TCPCGI_CLIENT_POLLTIME_MAX
#define TCPCGI_CLIENT_POLLTIME_MAX 60000
#endif

#ifndef TCPCGI_DAEMON_MAXERR
#define TCPCGI_DAEMON_MAXERR 10
#endif

#ifdef DEBUG
#define PRINT_LINE fprintf(stderr, "%s:%i:%s(): ", __FILE__, __LINE__, __func__); 
#define PRINTERR(x...) { PRINT_LINE; fprintf(stderr, x); fprintf(stderr, "\n"); }
#define PERROR(x) { PRINT_LINE; perror(x); }
#else
#define PRINT_LINE /**/
#define PRINTERR(x...) /**/
#define PERROR(x) perror(x);

#endif

#define TCPCGI_VERSION "0.0.7"

#endif
