/*
 	TSA Liedetector project.
		-- RKeene
*/

#include <stdio.h>
#ifndef GO32
#include <asm/io.h>
#else
#include <inlines/pc.h>
#endif
#include <unistd.h>
#include <string.h>
#include <signal.h>
#define CNT 8
#define DEBUG 0
int BASE=0x2f8;			/*     default to ttyS1 (COM2)    */
int NOTERM=0;


/* Clear the screen with ANSI escape sequences.  */
void clear(void)
{
	printf("%c[2J%c[H",27,27);
}
/*
  Allow us to easily switch between platforms, easy translation in this
  wrapper
*/
void soutb(unsigned char value, int address) {
#ifndef GO32
  outb(value,address);
#else
  outportb(value,address);
#endif
}

unsigned char sinb(int address) {
#ifndef GO32
  return(inb(address));
#else
  return(inportb(address));
#endif
}

/*  Reset the port turnning OFF the led. */
void handleC(void)
{
  if (NOTERM==1) { 
    signal(SIGINT,(void *)handleC);
#ifndef GO32
    signal(SIGTSTP,(void *)handleC);
#endif
    return; 
  }
  soutb(2,BASE+4);
#ifndef GO32
  ioperm(BASE,CNT,0);
#endif
  printf("%c[0m",27);
  clear();
  printf("Killed\n");
  exit(1);
}
void killed(void)
{
  NOTERM=0;
  handleC();
  printf("Hmm.. handleC() failed to terminate!  This is bad.. exiting.\n");
  while(1) { exit(127); }
}

void printstatus(int online, int value)
{
  char sonline[31];
  char liar[31];
  int trueValue;
  if (online==1) { strcpy(sonline,"Connected    "); } else { strcpy(sonline,"Not connected"); }
  trueValue=((value-61)*-1);
  if (trueValue<30) { strcpy(liar,"the truth"); } else { strcpy(liar,"a lie    "); }
  printf("%c[0m%c[H",27,27);
  printf("%c[1;37;44m%c[KStatus: %s   %c[%i;37;44m Measuring: %i\n%c[%i;37;41m%c[KSubject is telling %s",27,27,sonline,27,online,trueValue,27,online,27,liar);
  printf("\n");
}

/* I was REALLY bored... */
void flashled(char morse[128])
{
  int i,online,length=0,delay=150000;
  int lenstr=strlen(morse);
  soutb(1,BASE+4);
  for (i=0;i<5;i++) { online=sinb(BASE+6); }
  if (online!=128) { return; }
  for (i=0;i<lenstr;i++)
  {
    if (morse[i]=='.') length=150000;
    if (morse[i]=='-') length=450000;
    if (morse[i]==',') { usleep(650000); }
    if (morse[i]<=46 && morse[i]>=45) {
      soutb(1,BASE+4);
      usleep(length);
      soutb(2,BASE+4);
      usleep(delay);
    }
  }
}

int main(int argc, char *argv[])
{
  int i;
  int val[CNT];
  int online=2;
  int ionline;
  int valueLie=0;
  if (argc>=2)
  {
    if(strncasecmp("COM1",argv[1],4)==0) { BASE=0x3f8; }
    if(strncasecmp("COM2",argv[1],4)==0) { BASE=0x2f8; }
  }
#if (DEBUG==1)
  oldmain();
  return(0);
#endif
  signal(SIGINT,(void *)handleC);
  signal(SIGTERM,(void *)killed);
#ifndef GO32
  signal(SIGTSTP,(void *)handleC);
  if(ioperm(BASE,CNT,1)==-1) { printf("%c[0mYou must be %c[1;37mroot%c[0m to run this program.\n",27,27,27); return(1); }
#endif
  flashled(".-.,---,-.--,-.-,.,.,-.,.,");
  clear();
  while(1)
  {
    usleep(1);
    for (i=0;i<CNT;i++)
    {
      soutb(1,BASE+i);
      val[i]=sinb(BASE+i);
    }
    ionline=((val[6]-1)/128);
    if (online!=ionline || val[0]!=valueLie) {  
      online=ionline;
      valueLie=val[0];
      printstatus(online,val[0]);
    }
  }
  return(0);
}


/*
  Old main, used for learning what pins do what and what not, prints
     status.
*/
int oldmain(void) 
{
  int val[CNT];
  int i;
#ifndef GO32
  ioperm(BASE,CNT,1);
#endif
  while (1) {
    for (i=0;i<CNT;i++)
    {
      soutb(1,BASE+i);
      val[i]=sinb(BASE+i);
      printf("%i  ",val[i]);
    }
    printf("\n");
  }
  return 0;
}
