#include "timefn.h"

unsigned long GetClicks(void) {
    unsigned long now;
#ifdef NO_GETTOD
    struct tms dummy;
    now = (unsigned long) times(&dummy);
#else
    struct timeval date;
    struct timezone tz;
    gettimeofday(&date, &tz);
    now = date.tv_sec*1000000 + date.tv_usec;
#endif
    return now;
}
