#include "kbd.h"

/*
	Lock the keyboard at the hardware level.
*/
void disablekbd(void) {
  outb(0xa7,KBDBASE+4);
  outb(0xad,KBDBASE+4);
  outb(0xaf,KBDBASE+4);
}

/*
	Unlock the keyboard at the hardware level
*/
void enablekbd(void) {
  outb(0xa8,KBDBASE+4);
  outb(0xae,KBDBASE+4);
  outb(0xb0,KBDBASE+4);
  outb(0xf4,KBDBASE);
}

/*
	Check keyboard hardware status
*/
int checkkbdlock(void) {
  int stats;
  outb(0xa9,KBDBASE+4);
  stats=inb(KBDBASE);
  if (stats==1) { return 1; }
  return 0;
}

