/*

*/

#include <stdio.h>
#include <unistd.h>
#include "kbd.h"
#include "serial.h"
#include "timefn.h"

int COMBASE=0x2f8;


void exitcode(int code) {
  switch (code) {
  case 1:
    printf("Unable to access serial port.\nYou must be \033[1mroot\033[0m to run this program.\n");
    break;
  case 2:
    printf("Unable to access keyboard port.\nYou must be \033[1mroot\033[0m to run this program.\n");
    break;
  default:
    printf("Error (%5i) occured, exiting...\n",code);
  }
  exit(code);
}


int main(void) {
  if (ioperm(COMBASE, 16, 1)) exitcode(1);
  if (ioperm(KBDBASE, 16, 1)) exitcode(2);
  while(1) {
    printf("%i\n",!checkplug());
    usleep(500);
  }
  return(0);
}
