#include "config.h"

#define DISTLIB_TYPE_CALC_INT		1
#define DISTLIB_TYPE_CALC_FLOAT		2
#define DISTLIB_TYPE_EXEC		3
#define DISTLIB_TYPE_MEM		4

#define DISTLIB_COST_MEMSET		5

int  distlib_calc_int    (int   v1, int   v2, unsigned char op, int n, int cost);
int  distlib_calc_float  (float v1, float v2, unsigned char op, int n, int cost);
int  distlib_exec        (char path[127], char args[128][127], int cost);
int  distlib_memset      (char *name, char *value, int size);
int  distlib_sendmessage (void *message, int size, unsigned char typeid, int taskid, unsigned char cost);
void distlib_init	 (void);
void distlib_decode	 (char *data, int size);

struct distlib_msg_hdr {
	char	size[4];
	int	taskid;
	char	typeid;
	char	cost;	
};

// For now we use INT and hope everyone has the same size INT.
// Things could get weird on heterogenous networks
struct distlib_calc_msg1 {
	int	v1;
	int	v2;
	char	op;
};

struct distlib_calc_msg2 {
	float	v1;
	float	v2;
	char	op;
};

struct distlib_exec_msg {
	char	path[127];
	char	args[128][127];
};

struct distlib_mem {
	char	name[64];
	int	size;	
	char	*value;
};

struct distlib_msg_reply {
	int 	size;
	char 	*value;
};
