/*
	Main library.	See Docs/model.txt (or perhaps, you should just try to dicipher
	the comments in the code instead.)
	
	-- Roy Keene [151119990247] rkeene@suspend.net
*/

#include <string.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#ifdef DEBUG
#include <stdio.h>
#endif
#include "distlib.h"
#include "net.h"

int distlib_server_fd=-1;

int distlib_calc_int (int v1, int v2, unsigned char op, int n, int cost) {
	struct distlib_calc_msg1 mesg;
	mesg.v1=v1;
	mesg.v2=v2;
	mesg.op=op;
#ifdef DEBUG
	printf("distlib.c: distlib_calc_int(%i, %i, %i, %i, %i)\n",v1,v2,op,n,cost);
	printf("distlib.c: distlib_calc_int: sizeof(mesg)=%i\n",sizeof(mesg));
	printf("distlib.c: distlib_calc_int: sizeof(distlib_calc_msg1)=%i\n",sizeof(struct distlib_calc_msg1));
#endif
	return(distlib_sendmessage(&mesg, sizeof(mesg)-3, DISTLIB_TYPE_CALC_INT, 0, cost));
}

int distlib_calc_float (float v1, float v2, unsigned char op, int n, int cost) {
	struct distlib_calc_msg2 mesg;
	mesg.v1=v1;
	mesg.v2=v2;
	mesg.op=op;
#ifdef DEBUG
	printf("distlib.c: distlib_calc_float(%f, %f, %i, %i, %i)\n",v1,v2,op,n,cost);
	printf("distlib.c: distlib_calc_float: sizeof(mesg)=%i\n",sizeof(mesg));
#endif
	return(distlib_sendmessage(&mesg, sizeof(mesg)-3, DISTLIB_TYPE_CALC_FLOAT, 0, cost));
}

int distlib_exec (char path[127], char args[128][127], int cost) {
	struct distlib_exec_msg mesg;
	strcpy(mesg.path,path);
	return(-1);
}


int distlib_memset (char *name, char *value, int size) {
	struct distlib_mem *mesg;
	int taskid;
	mesg=malloc(size+64+sizeof(size));
	mesg->size=size;
#ifdef DEBUG
	printf("distlib.c: distlib_memset(\"%s\",\"%s\",%i)\n",name,value,size);
	strncpy(mesg->name,name,63);
	printf("distlib.c: distlib_memset: strncpy(mesg.name, name, 63)\n");
	strcpy(&mesg->value,value);
	printf("distlib.c: distlib_memset: strcpy(mesg.value,value)\n");
#else
	strncpy(mesg->name,name,63);
	strcpy(mesg->value,value);
#endif
	taskid=distlib_sendmessage(mesg,size+64+sizeof(size),DISTLIB_TYPE_MEM, 0, DISTLIB_COST_MEMSET);
	free(mesg);
	return(taskid);
}

/*
distlib_msg_reply *distlib_getmem(char *name) {
	
}
*/

int distlib_sendmessage (void *message, int size, unsigned char typeid, int taskid, unsigned char cost) {
	struct distlib_msg_hdr hdr;
	char dest[(sizeof(hdr)+size)];
	int new_taskid=0;
#ifdef DEBUG
	int i;
#endif
	hdr.size[0]=sizeof(dest)&0xff;
	hdr.size[1]=sizeof(dest)&0xff00;
	hdr.size[2]=sizeof(dest)&0xff0000;
	hdr.size[3]=sizeof(dest)&0xff000000;
	hdr.typeid=typeid;
	hdr.cost=cost;
	hdr.taskid=taskid;
#ifdef DEBUG
	printf("distlib.c: distlib_sendmessage(%lu, %i, %i, %i)\n",(unsigned long) &message, size, typeid, cost);
	if (distlib_server_fd==-1) distlib_init();
	printf("distlib.c: distlib_sendmessage: dest[]={");
#else
	if (distlib_server_fd==-1) distlib_init();
#endif
	memcpy((void *) dest, &hdr, sizeof(hdr));
	memcpy(((void *) dest)+sizeof(hdr), message, size);
	write(distlib_server_fd,&dest,sizeof(dest));
#ifdef DEBUG
	for (i=0;i<sizeof(dest);i++)
		printf("%i ", dest[i]);
	printf("}\n");
#endif
	return(new_taskid);
}

void distlib_init (void) {
#ifdef DEBUG
	printf("distlib.c: distlib_init()\n");
#endif
	if (distlib_server_fd!=-1) return;
	distlib_server_fd=createconnection_tcp("10.0.0.1",PORT);
	return;
}

void distlib_decode (char *data, int size) {
	unsigned long packet_size;
	int loc=0;
	struct distlib_msg_hdr hdr;
	while (1) {
		memcpy(&hdr, data, sizeof(hdr));
		packet_size=hdr.size[0]+(hdr.size[1]<<8)+(hdr.size[2]<<16)+(hdr.size[3]<<24);

		printf("%lu, %i, %i\n",packet_size, hdr.typeid, hdr.cost);
		switch (hdr.typeid) {
			case DISTLIB_TYPE_CALC_INT:
				break;
		}
		loc+=packet_size;
		if (loc>=size) break;		
	}
}


