/*
	Example block compression routine for interfacing with DCL.

*/

#include "compress.h"
#ifdef USE_ZLIB
#include "comp_luck.h"
#include "buffer.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <zlib.h>


/*
	mode 		- DCL_MODE_COMPR or DCL_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_luck_algo(int mode, char *prev_block, char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DCL_MODE_COMPR:
			return(comp_luck_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DCL_MODE_DECMP:
			return(comp_luck_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_luck_compress(char *prev_block, char *curr_block, char *out_block, int blk_size) {
	uLong crc=crc32(0L, Z_NULL, 0);
	int i,x=0,y;
	char *tmp_buff;
	tmp_buff=malloc(blk_size);

	bit_buffer_purge();

	crc=crc32(crc, curr_block, blk_size);
	memcpy(out_block,&crc,sizeof(crc));
	x+=sizeof(crc);

	for (i=0;i<blk_size;i++) {
		bit_buffer_write(((unsigned char) curr_block[i])>>2,6);
		y=bit_buffer_size();
		if (y>=8) out_block[++x]=bit_buffer_read(8);
	}

	y=comp_luck_decompress(NULL, out_block, tmp_buff, x);
	if (memcmp(tmp_buff,curr_block,blk_size)!=0) {
		free(tmp_buff);
		return(-1);
	}
	free(tmp_buff);
printf("Success!\n");
	return(x);
}

int comp_luck_decompress(char *prev_block, char *curr_block, char *out_block, int blk_size) {
	int i=0,x=0,y=0;
	int succ=0;
	uLong crc=crc32(0L, Z_NULL, 0);
	uLong fcrc=0;

	bit_buffer_purge();

	memcpy(&fcrc,curr_block,sizeof(fcrc));
	i=sizeof(fcrc);

	/* Write the 6 bits into the byte buffer */
	while (1) {
		if ((i-sizeof(fcrc))==blk_size || x==DCL_BLK_SIZE) break;
		if (bit_buffer_size()<6)
			bit_buffer_write((unsigned char) curr_block[++i],8);
		out_block[x++]=bit_buffer_read(6);
	}

	while (1) {
		crc=crc32(0L, Z_NULL, 0);
		for (i=0;i<DCL_BLK_SIZE;i++) {
			if ((((unsigned char) (out_block[i]))>>6)<3) {
				out_block[i]+=64;
				break;
			} else {
				out_block[i]-=192;
			}
		}
		for (y=10;y>=0;y--) {
			printf("%i%i",((unsigned char) (out_block[y]))>>7,(((unsigned char) (out_block[y]))>>6)&1);
		}
		printf("\n");
		if ((i-1)==x) break;
		crc=crc32(crc, out_block, x);
		if (crc==fcrc) {
			succ=1;
			break;
		}
	}
	printf("%i\n",succ);
	if (succ) {
		return(x);
	} else {
		return(0);
	}
}
#endif
