/*
 * Copyright (C) 2000  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *      email: rkeene@netfueldesign.com
 */


#include "dact.h"
#ifdef USE_ZLIB
#include "comp_mzlib.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <zlib.h>


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_mzlib_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_mzlib_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_mzlib_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_mzlib_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned long dest_size;
	char *tmp_block;
	int retval;
	int i;

	dest_size=(int) ((float) (blk_size*1.02)+15);

	tmp_block=malloc(dest_size);
	memcpy(tmp_block,curr_block,blk_size);

	for (i=0;i<blk_size;i++) {
/*
		tmp_block[i]=( \
			(  (tmp_block[i]&0x80) >> 7 ) + \
			(  (tmp_block[i]&0x20) >> 4 ) + \
			(  (tmp_block[i]&0x08) >> 1 ) + \
			(  (tmp_block[i]&0x02) << 2 ) + \
			(  (tmp_block[i]&0x40) >> 2 ) + \
			(  (tmp_block[i]&0x10) << 1 ) + \
			(  (tmp_block[i]&0x04) << 4 ) + \
			(  (tmp_block[i]&0x01) << 7 ) \
		);
*/
		tmp_block[i]=( ((tmp_block[i]&0xf0)>>4) + (  (tmp_block[i]&0x0f)  <<4) );
	}
	retval=compress(out_block, &dest_size, tmp_block, blk_size);
	if (retval!=Z_OK) {
		printf("zlib compression failed.\n");
		return(blk_size*2);
	}
	return(dest_size);
}

int comp_mzlib_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned long dest_size=(DACT_BLK_SIZE*2);
	int retval;
	int i;

	retval=uncompress(out_block,&dest_size,curr_block,blk_size);

	if (retval!=Z_OK) {
		printf("zlib decompression failed.\n");
		return(0);
	}

	for (i=0;i<dest_size;i++) {
		out_block[i]=( ( (out_block[i]&0xf0)>>4) + ((out_block[i]&0x0f)<<4) );
	}

	return(dest_size);
}

#endif
