/*
	Example block compression routine for interfacing with DACT.

*/


#include "dact.h"
#include "comp_rle.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_rle_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_rle_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_rle_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_rle_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	int i,x=0,m;
	unsigned char sentinel=0xff;
	unsigned char currchar, prevchar;
	unsigned char charcnt=0;
	unsigned int lowestcnt=0xffff;
	unsigned int count[256];

	for (i=0;i<256;i++) count[i]=0;

	for (i=0;i<blk_size;i++) count[curr_block[i]]++;

	for (i=0;i<256;i++) {
		if (count[i]<lowestcnt) {
			sentinel=i;
			lowestcnt=count[i];
		}
	}

	out_block[x++]=sentinel;

	prevchar=curr_block[0];
	for (i=0;i<(blk_size+1);i++) {
		currchar=curr_block[i];
		if (prevchar!=currchar || charcnt==255 || i>=(blk_size)) {
			if (charcnt<=2 && prevchar!=sentinel) {
				for (m=0;m<charcnt;m++) out_block[x++]=prevchar;
			} else {
				out_block[x++]=sentinel;
				out_block[x++]=prevchar;
				out_block[x++]=charcnt;
			}
			charcnt=0;
		}
		charcnt++;
		prevchar=currchar;
	}
	return(x);
}

int comp_rle_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	int i,x=0,m;
	unsigned char sentinel=curr_block[0];
	unsigned char currchar;
	unsigned char charcnt;

	for (i=1;i<blk_size;i++) {
		currchar=curr_block[i];
		if (currchar==sentinel) {
			currchar=curr_block[++i];
			charcnt=curr_block[++i];
			if ((x+charcnt)>DACT_BLK_SIZE) {
				printf("Error in RLE compression!\n");
				return(0);
			}
			for (m=0;m<charcnt;m++) out_block[x++]=currchar;
		} else {
			out_block[x++]=currchar;
		}
	}
	return(x);
}
