/*
	Use "Range Encoding."

	Needs alot of work.

*/


#include "dact.h"
#include "comp_range.h"
#include <stdio.h>
#include <stdlib.h>
#include "buffer.h"

#include "comp_range/rangecod.h"
#include "comp_range/port.h"


char tmp_block[DACT_BLK_SIZE];
int count_i=0;

/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_range_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_range_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_range_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_range_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned int ch;
	freq counts[257];
	rangecoder rc;
	int i,x;
//printf("Starting Range Encoder...\n");
	start_encoding(&rc,0,0);

	for (x=0;x<257;x++) counts[x]=0;
	for (x=0;x<blk_size;x++) counts[curr_block[x]]++;

	encode_freq(&rc,1,1,2);

	for (x=0;x<256;x++) encode_short(&rc,counts[x]);

	counts[256]=blk_size;
	for (x=256; x; x--) counts[x-1]=counts[x]-counts[x-1];

	byte_buffer_purge();

	for (i=0;i<blk_size;i++) {
		ch=curr_block[i];
		byte_buffer_write(&ch,1);
//printf("i=%5i ch=0x%02x -- counts[ch+1]=0x%02x counts[ch]=0x%02x\n",i,ch,counts[ch+1],counts[ch]);
		encode_freq(&rc,counts[ch+1]-counts[ch],counts[ch],counts[256]);
	}

	encode_freq(&rc,1,0,2);

	done_encoding(&rc);
//printf("Range Encoder done...\n");


	if (count_i>blk_size) return(-1);
	for (i=0;i<count_i;i++) {
		out_block[i]=tmp_block[i];
	}

	return(count_i);
}

int comp_range_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	printf("Not yet supported.\n");
	return(0);
}

void incoming_data(unsigned char value) {
//	printf("%i\n",value);
	tmp_block[count_i++]=value;
}
