#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "dact.h"
#include "buffer.h"

TWO_BYTES bit_buffer_data=0;
int bit_buffer_location=0;

char byte_buffer_data[BYTE_BUFF_SIZE];
int byte_buffer_location=-1;


/*
    Func: bit_buffer_read
    Args: 
           bits		- (int) Number of bits to read from the buffer.
    Rets: Int, value from buffer.
    Meth: Bread high BITS bits from BUFFER_DATA and shift to the left.
    Stat: Complete

*/
int bit_buffer_read(int bits) {
        int retval;
        if (bits>bit_buffer_location) { 
		printf("buffer.c: bit_buffer_read: Request for %i bits, buffer contains %i bits\n",bits,bit_buffer_location);
		bits=bit_buffer_location;
	}

        retval=(bit_buffer_data>>((sizeof(bit_buffer_data)*8)-bits));
        bit_buffer_data=(bit_buffer_data<<bits);
        bit_buffer_location-=bits;
        return(retval);
}

/*
    Func: bit_buffer_write
    Args:
           val		- (uint) Value to write
           bits		- (uint) Number of bits to allocate
    Rets: Nothing
    Meth: Add to right of current BUFFER_DATA[BUFFER_LOCATION], incremint
            BUFFER_LOCATION
    Stat: Complete
*/
void bit_buffer_write(unsigned int val, unsigned int bits) {
        if ((bits+bit_buffer_location)>(sizeof(bit_buffer_data)*8)) {
                printf("buffer.c: bit_buffer_write: Buffer overflow\n");
                return;
        }
        if ((val>>bits)!=0) {
                printf("buffer.c: bit_buffer_write: Value (%i) is bigger than %i bits.\n",val,bits);
                return;
        }
        bit_buffer_location+=bits;
        bit_buffer_data+=(val<<((sizeof(bit_buffer_data)*8)-bit_buffer_location));
        return;
}


/*
    Func: bit_buffer_size
    Args: None
    Rets: Int, number of bits in buffer
    Meth: buffer_location
    Stat: Complete
*/
int bit_buffer_size(void) {
        return(bit_buffer_location);
}


/*
    Func: bit_buffer_purge
    Args: None
    Rets: Nothing
    Meth: Clear BUFFER_DATA and set BUFFER_LOCATION to 0
*/
void bit_buffer_purge(void) {
        bit_buffer_location=0;
        bit_buffer_data=0;
        return;
}


char *byte_buffer_read(int bytes) {
	char *retval;
	if (byte_buffer_location==-1) return(NULL);
	if (bytes>byte_buffer_location) {
		printf("buffer.c: byte_buffer_read: Request for more bytes than queued.\n");
		bytes=byte_buffer_location;
	}
	retval=malloc(bytes);
	memcpy(retval,byte_buffer_data,bytes);
	memmove(byte_buffer_data,byte_buffer_data+byte_buffer_location,(byte_buffer_location-=bytes));
	return(retval);
}

void byte_buffer_write(char *val, unsigned int size) {
	if (byte_buffer_location==-1) byte_buffer_purge();
	if ((byte_buffer_location+size)>sizeof(byte_buffer_data)) {
		printf("buffer.c: byte_buffer_write: Buffer overflow.\n");
		return;
	}
	memcpy(byte_buffer_data+byte_buffer_location,val,size);
	byte_buffer_location+=size;
}

int byte_buffer_size(void) {
	return(byte_buffer_location);
}

void byte_buffer_purge(void) {
	int i;
	if (byte_buffer_location==-1) {
		for (i=0;i<BYTE_BUFF_SIZE;i++) byte_buffer_data[i]=0;
	} else {
		for (i=0;i<(byte_buffer_location+1);i++) byte_buffer_data[i]=0;
	}
	byte_buffer_location=0;
}

