/*
	Example block compression routine for interfacing with DACT.

	Uses zlib.
*/


#include "dact.h"
#ifdef USE_ZLIB
#include "comp_zlib.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <zlib.h>


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_zlib_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_zlib_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_zlib_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_zlib_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned long dest_size;
	int retval;
	dest_size=(int) ((float) (blk_size*1.01)+13);
	retval=compress(out_block, &dest_size, curr_block, blk_size);
	if (retval!=Z_OK) {
		printf("zlib compression failed.\n");
		return(blk_size*2);
	}
	return(dest_size);
}

int comp_zlib_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned long dest_size;
	int retval;

	dest_size=(DACT_BLK_SIZE*2);
	retval=uncompress(out_block,&dest_size,curr_block,blk_size);


	if (retval!=Z_OK) {
		printf("zlib decompression failed.\n");
		return(0);
	}
	return(dest_size);
}
#endif
