/*
	Example block compression routine for interfacing with DACT.

*/


#include "dact.h"
#include "comp_text.h"
#include "buffer.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_text_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_text_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_text_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_text_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned char low_byte=255, high_byte=0;
	unsigned char byte_buf;
	unsigned int range;
	int i,x=0,y;


	bit_buffer_purge();

	for (i=0;i<blk_size;i++) {
		if (((unsigned char) curr_block[i])<low_byte) low_byte=curr_block[i];
		if (((unsigned char) curr_block[i])>high_byte) high_byte=curr_block[i];
	}

	range=(unsigned int) (high_byte-low_byte);

	out_block[x++]=low_byte;
	out_block[x++]=high_byte;

	if (range==0)
		return(2);

	for (y=1;y<=8;y++)
		if ((range>>y)==0) break;
	if (y==8) return(-1);

	for (i=0;i<blk_size;i++) {
		byte_buf=(unsigned char) (curr_block[i]-low_byte);
		if ((byte_buf>>y)==1) {
			return(-1);
		}
		bit_buffer_write(byte_buf,y);

		while (bit_buffer_size()>=8) {
			out_block[x++]=bit_buffer_read(8);
		}
	}

	return(x);
}

int comp_text_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned char high_byte, low_byte;
	unsigned int range;
	int i=0,x=0,y;
	
	low_byte=curr_block[x++];
	high_byte=curr_block[x++];
	range=(unsigned int) (high_byte-low_byte);

	if (range==0) {
		memset(out_block,low_byte,DACT_BLK_SIZE);
		return(DACT_BLK_SIZE);
	}

        for (y=1;y<=8;y++)
                if ((range>>y)==0) break;

	bit_buffer_purge();

	while (1) {
		if (bit_buffer_size()<y) bit_buffer_write((unsigned char) curr_block[x++],8);
		out_block[i++]=bit_buffer_read(y);
		if ((x==blk_size) && (bit_buffer_size()<y)) break;
	}

	return(i);
}
