/*
	Compress by gathering bytes that are most often placed near each other
	and rearranging the ASCII Charectar Set to make those bytes have
	similar values.

*/


#include "dact.h"
#include "comp_mzlib2.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include "sort.h"
#define SQRD_256 65536


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_mzlib2_algo(int mode, unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_mzlib2_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_mzlib2_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_mzlib2_compress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	unsigned int freq[SQRD_256];
	int i;
	for (i=0;i<blk_size;i++)
		freq[(curr_block[i]<<8)+(curr_block[i+1])]++;

	int_sort_fast(freq, SQRD_256);

	for (i=0;i<(SQRD_256);i++) {
		printf("%i: %i and %i are near each other %i times\n",i,(freq[i]>>24),(freq[i]>>16)&0xff,freq[i]&0xffff);
	}
	return(-1);
}

int comp_mzlib2_decompress(unsigned char *prev_block, unsigned char *curr_block, char *out_block, int blk_size) {
	printf("Not yet supported.\n");
	return(0);
}
