/*
	Algorithms!
*/


#include "comp_plain.h"
#include "comp_rle.h"
#include "comp_delta.h"
#ifdef USE_ZLIB
#include "comp_zlib.h"
#include "comp_mzlib.h"
#endif
#ifdef DEBUG
#ifdef USE_ZLIB
#include "comp_mzlib2.h"
#endif
#include "comp_factor.h"
#include "comp_range.h"
#endif
#include "comp_text.h"
#include "comp_fail.h"

int (*(algorithms[256]))()={    comp_plain_algo,
                                comp_rle_algo,
                                comp_delta_algo,
				comp_text_algo,
#ifdef USE_ZLIB
				comp_zlib_algo,
				comp_mzlib_algo,
#else
				comp_fail_algo,
				comp_fail_algo,
#endif
#ifdef DEBUG
				comp_factor_algo,
#ifdef USE_ZLIB
				comp_mzlib2_algo,
#else
				comp_fail_algo,
#endif
				comp_range_algo,
#else
				comp_fail_algo,
				comp_fail_algo,
				comp_fail_algo,
#endif
                                NULL};

char *algorithm_names[256]={	"Uncompressed",
				"RLE Compression",
				"Delta Compression",
				"Text Compression",
#ifdef USE_ZLIB
				"Zlib Compression",
				"Modified Zlib Compression",
#else
				"Unsupported Algorithm (zlib)",
				"Unsupported Algorithm (mzlib)",
#endif
#ifdef DEBUG
				"Factor Compression",
#ifdef USE_ZLIB
				"Second Modified Zlib",
#else
				"Unsupported Algorithm (mzlib2)",
#endif
				"Range Encoding",
#else
				"Unsupported Algorithm (factor)",
				"Unsupported Algorithm (mzlib2)",
				"Unsupported Algorithm (range)",
#endif
				NULL
			};
