/*
	Dynamic Compression Routines 
		- OR -
	Compression dictionary.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "compress.h"
#include "algorithms.h"

int print_help(int argc, char **argv) {
	printf("DACT version %i.%i.%i.\n",DACT_VER_MAJOR,DACT_VER_MINOR,DACT_VER_REVISION);
	printf("Usage:\n\t%s [-d] <filename> [outfile]\n",argv[0]);
	printf("  -d\tDecompress instead of compressing.\n");
	return(0);
}



int main(int argc, char **argv) {
	char in_filename[128], out_filename[128];
	char in_buffer[DACT_BLK_SIZE], prev_buffer[DACT_BLK_SIZE];
	char out_buffer[DACT_BLK_SIZE*2];
	char cmp_options=0;
	char file_version[3]={DACT_VER_MAJOR, DACT_VER_MINOR, DACT_VER_REVISION};
	char option_verbose=0;
	char completed;
	int in_fd, out_fd;
	int i,x=0;
	int out_size=-1, out_lowest, out_algo=-1;
	int file_size, out_file_size;
	int mode=DACT_MODE_COMPR, offset_arg=0;
	int mode_force=0;
	struct stat statinfo;
	struct dact_header header;


//	if (argc==1) {
//		return(!print_help(argc,argv));
//	}

	while (1) {
		if (argv[1+offset_arg]!=NULL) {
			completed=0;
			if (!strncmp(argv[1+offset_arg],"-d",2)) {
				mode=DACT_MODE_DECMP;
				completed=1;	
			}
			if (!strncmp(argv[1+offset_arg],"-f",2)) {
				mode_force=1;
				completed=1;
			}
			if (!strncmp(argv[1+offset_arg],"-v",2)) {
				option_verbose=1;
				completed=1;
			}
			if (!strncmp(argv[1+offset_arg],"--",2)) {
				offset_arg++;
				completed=0;
			}
			if (completed==0) break;
			offset_arg++;
		} else {
			break;
		}
	}


	for (i=0;i<sizeof(prev_buffer);i++) prev_buffer[i]=0;
	if (argv[1+offset_arg]==NULL) {
		in_filename[0]=0;
	} else {
		strncpy(in_filename,argv[1+offset_arg],sizeof(in_filename)-1);
	}

	if (!strcmp(in_filename,"-") || in_filename[0]==0) {
		in_fd=STDIN_FILENO;
	} else { 
		in_fd=open(in_filename,O_RDONLY);
	}

	if (argc==(3+offset_arg)) {
		strncpy(out_filename,argv[2+offset_arg],sizeof(out_filename)-1);
		if (!access(out_filename, F_OK)) {
			if (mode_force) {
				unlink(out_filename);
			} else {
				printf("%s: %s exists, exiting.\n",argv[0],out_filename);
				close(in_fd);
				return(-1);
			}
		}

		out_fd=open(out_filename,O_WRONLY|O_CREAT,0644);
	} else {
		if (isatty(STDERR_FILENO)) {
			printf("%s: Refusing to write compressed output to a terminal.\n",argv[0]);
			return(-1);
		} else {
			out_fd=STDERR_FILENO;
		}
	}


	fstat(in_fd, &statinfo);
	file_size=statinfo.st_size;

	switch (mode) { 
		case DACT_MODE_COMPR:
			write(out_fd,&file_version,sizeof(file_version));
			write(out_fd,&file_size,sizeof(file_size));
			write(out_fd,&cmp_options,sizeof(cmp_options));
			while (1) {
				x++;
				out_lowest=DACT_BLK_SIZE*2;
				if (read(in_fd,&in_buffer,sizeof(in_buffer))==0) break;
				for (i=0;i<255;i++) {
					if (algorithms[i]==NULL) break;
					out_size=algorithms[i](DACT_MODE_COMPR, &prev_buffer, &in_buffer, &out_buffer, sizeof(in_buffer));
					if (option_verbose)
						printf("  --       algo #%i: size=%i\n",i,out_size);
					if (out_size<out_lowest && (out_size > 0)) {
						out_algo=i;
						out_lowest=out_size;
					}
					memcpy(prev_buffer,in_buffer,sizeof(in_buffer));
				}
				if (out_lowest==(DACT_BLK_SIZE*2)) {
					printf("Compression resulted in DACT_BLK_SIZE*2 !  Aborting.\n");
					return(-1);
				}
				out_size=algorithms[out_algo](DACT_MODE_COMPR, &prev_buffer, &in_buffer, &out_buffer, sizeof(in_buffer));
				printf("Block #%i: algo=%i (size=%i,%i)\n", x,out_algo,out_size,out_size+sizeof(header.algo)+sizeof(header.size));
				header.size=(TWO_BYTES) (out_size);
				header.algo=out_algo;
				write(out_fd,&header.size,sizeof(header.size));
				write(out_fd,&header.algo,sizeof(header.algo));
				write(out_fd,&out_buffer,out_size);
//				if ((x*DACT_BLK_SIZE)>=file_size) break;
			}
			break;
		case DACT_MODE_DECMP:
			i=0;
			read(in_fd,&file_version,sizeof(file_version));
			read(in_fd,&out_file_size,sizeof(out_file_size));
			read(in_fd,&cmp_options,sizeof(cmp_options));
			x=sizeof(out_file_size)+sizeof(cmp_options);

			if (file_version[0]!=DACT_VER_MAJOR) {
				printf("Major version numbers do not match! (%i!=%i)\n",file_version[0],DACT_VER_MAJOR);
				printf("File is not usable, exiting...\n");
				close(in_fd);
				close(out_fd);
				return(-1);
			}
			if (file_version[1]!=DACT_VER_MINOR || file_version[2]!=DACT_VER_REVISION) {
				printf("Minor or Revision numbers do not match (file=%i.%i.%i != current=%i.%i.%i)\n",file_version[0],file_version[1],file_version[2],DACT_VER_MAJOR,DACT_VER_MINOR,DACT_VER_REVISION);
				printf("File may not be usuable.\n");
			}


			while(1) {
				i++;
				read(in_fd,&header.size,sizeof(header.size));
				read(in_fd,&header.algo,sizeof(header.algo));
				read(in_fd,&in_buffer,header.size);
				x+=sizeof(header.size)+sizeof(header.algo)+header.size;
				out_size=algorithms[header.algo](DACT_MODE_DECMP, &prev_buffer, &in_buffer, &out_buffer, header.size);
				if (out_size!=DACT_BLK_SIZE) {
					printf("Block resulted in data that is less than %i bytes.\n",DACT_BLK_SIZE);
					close(in_fd);
					close(out_fd);
					return(-1);
				}
				printf("Block #%i: algo=%i (size=%i,%i)\n",i,header.algo,header.size,header.size+3);
				if (((i*DACT_BLK_SIZE))>=out_file_size) {
					out_size-=((i*DACT_BLK_SIZE)-out_file_size);
				}
				write(out_fd,&out_buffer,out_size);
				if (x>=file_size) break;
				memcpy(prev_buffer,out_buffer,out_size);
			}
			break;
	}

	close(in_fd);
	close(out_fd);

	return(0);
}
