/*
	Example block compression routine for interfacing with DACT.

	This does no compression.

	(This is used as the minimum case, so block can be atmost blk_size
	+3 bytes in size)
*/


#include "compress.h"
#include "comp_plain.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>


/*
	mode 		- DACT_MODE_COMPR or DACT_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_plain_algo(int mode, char *prev_block, char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DACT_MODE_COMPR:
			return(comp_plain_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DACT_MODE_DECMP:
			return(comp_plain_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_plain_compress(char *prev_block, char *curr_block, char *out_block, int blk_size) {
	memcpy(out_block,curr_block,blk_size);
	return(blk_size);
}

int comp_plain_decompress(char *prev_block, char *curr_block, char *out_block, int blk_size) {
	memcpy(out_block,curr_block,blk_size);
	return(blk_size);
}
