/*
	Dynamic Compression Routines 
		- OR -
	Compression dictionary.
*/

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>
#include "compress.h"
#include "algorithms.h"

int print_help(int argc, char **argv) {
	printf("DCL version %i.%i.%i.\n",DCL_VER_MAJOR,DCL_VER_MINOR,DCL_VER_REVISION);
	printf("Usage:\n\t%s [-d] <filename> [outfile]\n",argv[0]);
	printf("  -d\tDecompress instead of compressing.\n");
	return(0);
}



int main(int argc, char **argv) {
	char in_filename[128], out_filename[128];
	char in_buffer[DCL_BLK_SIZE], prev_buffer[DCL_BLK_SIZE];
	char out_buffer[DCL_BLK_SIZE*2];
	char cmp_options=0;
	int in_fd, out_fd;
	int i,x=0;
	int out_size=-1, out_lowest, out_algo=-1;
	int file_size, out_file_size;
	int mode=DCL_MODE_COMPR, offset_arg=0;
	struct stat statinfo;
	struct dcl_header header;


	if (argc==1) {
		return(!print_help(argc,argv));
	}

	if (!strncmp(argv[1],"-d",2)) {
		offset_arg=1;
		mode=DCL_MODE_DECMP;
	}

	for (i=0;i<sizeof(prev_buffer);i++) prev_buffer[i]=0;

	strncpy(in_filename,argv[1+offset_arg],sizeof(in_filename)-1);
	in_fd=open(in_filename,O_RDONLY);
	if (argc==(3+offset_arg)) {
		strncpy(out_filename,argv[2+offset_arg],sizeof(out_filename)-1);
		out_fd=open(out_filename,O_WRONLY|O_CREAT,0644);
	} else {
		out_fd=STDERR_FILENO;
	}


	fstat(in_fd, &statinfo);
	file_size=statinfo.st_size;

	switch (mode) { 
		case DCL_MODE_COMPR:
			write(out_fd,&file_size,sizeof(file_size));
			write(out_fd,&cmp_options,sizeof(cmp_options));
			while (1) {
				x++;
				out_lowest=DCL_BLK_SIZE*2;
				read(in_fd,&in_buffer,sizeof(in_buffer));
				for (i=0;i<255;i++) {
					if (algorithms[i]==NULL) break;
					out_size=algorithms[i](DCL_MODE_COMPR, &prev_buffer, &in_buffer, &out_buffer, sizeof(in_buffer));
//					printf("Block #%i: algo #%i: size=%i\n",x,i,out_size);
					if (out_size<out_lowest && (out_size > 0)) {
						out_algo=i;
						out_lowest=out_size;
					}
					memcpy(prev_buffer,in_buffer,sizeof(in_buffer));
				}
				if (out_lowest==(DCL_BLK_SIZE*2)) {
					printf("Compression resulted in DCL_BLK_SIZE*2 !  Aborting.\n");
					return(-1);
				}
				out_size=algorithms[out_algo](DCL_MODE_COMPR, &prev_buffer, &in_buffer, &out_buffer, sizeof(in_buffer));
				printf("Block #%i: algo=%i (size=%i,%i)\n", x,out_algo,out_size,out_size+sizeof(header.algo)+sizeof(header.size));
				header.size=(TWO_BYTES) (out_size);
				header.algo=out_algo;
				write(out_fd,&header.size,sizeof(header.size));
				write(out_fd,&header.algo,sizeof(header.algo));
				write(out_fd,&out_buffer,out_size);
				if ((x*DCL_BLK_SIZE)>=file_size) break;
			}
			break;
		case DCL_MODE_DECMP:
			i=0;
			read(in_fd,&out_file_size,sizeof(out_file_size));
			read(in_fd,&cmp_options,sizeof(cmp_options));
			x=sizeof(out_file_size)+sizeof(cmp_options);
			while(1) {
				i++;
				read(in_fd,&header.size,sizeof(header.size));
				read(in_fd,&header.algo,sizeof(header.algo));
				read(in_fd,&in_buffer,header.size);
				x+=sizeof(header.size)+sizeof(header.algo)+header.size;
				out_size=algorithms[header.algo](DCL_MODE_DECMP, &prev_buffer, &in_buffer, &out_buffer, header.size);
				printf("Block #%i: algo=%i (size=%i,%i)\n",i,header.algo,header.size,header.size+3);
				if (((i*DCL_BLK_SIZE))>=out_file_size) {
					printf("%i\n",DCL_BLK_SIZE-((i*DCL_BLK_SIZE)-out_file_size));
					out_size-=((i*DCL_BLK_SIZE)-out_file_size);
				}
				write(out_fd,&out_buffer,out_size);
				if (x>=file_size) break;
				memcpy(prev_buffer,out_buffer,out_size);
			}
			break;
	}

	close(in_fd);
	close(out_fd);

	return(0);
}
