/*
	Example block compression routine for interfacing with DCL.

*/


#include "compress.h"
#include "comp_rle.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>


/*
	mode 		- DCL_MODE_COMPR or DCL_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_rle_algo(int mode, char *prev_block, char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DCL_MODE_COMPR:
			return(comp_rle_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DCL_MODE_DECMP:
			return(comp_rle_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_rle_compress(char *prev_block, char *curr_block, char *out_block, int blk_size) {
	return(-1);
}

int comp_rle_decompress(char *prev_block, char *curr_block, char *out_block, int blk_size) {
	printf("Not yet supported.");
	return(0);
}
