/*
	Example block compression routine for interfacing with DCL.

*/


#include "compress.h"
#include "comp_delta.h"
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>


/*
	mode 		- DCL_MODE_COMPR or DCL_MODE_DECMP
			    Determine whether to compress or decompress.
	prev_block	- Previous (uncompressed) block.
	curr_block	- The data to be compressed.
	out_block	- Where to put data after compression.
	blk_size	- Size of prev_block and curr_block.
*/
int comp_delta_algo(int mode, char *prev_block, char *curr_block, char *out_block, int blk_size) {
	switch(mode) {
		case DCL_MODE_COMPR:
			return(comp_delta_compress(prev_block,curr_block,out_block,blk_size));
			break; /* Heh */
		case DCL_MODE_DECMP:
			return(comp_delta_decompress(prev_block,curr_block,out_block,blk_size));
			break;
		default:
			printf("Unsupported mode: %i\n", mode);
			return(-1);
	}
}

int comp_delta_compress(char *prev_block, char *curr_block, char *out_block, int blk_size) {
	int i,x=0,y=0;
	char Val;
	char CurrByte, PrevByte;
	char DeltaByte;
	TWO_BYTES BitBuff=0;

	CurrByte=curr_block[0];
	out_block[x]=CurrByte;
	for (i=1;i<blk_size;i++) {
		PrevByte=CurrByte;
		CurrByte=curr_block[i];
		DeltaByte=(CurrByte-PrevByte);
		if (abs(DeltaByte)>32) {
			y+=7;
			Val=(((1<<6) | ((((DeltaByte/abs(DeltaByte))+1)/2)<<5) | (DeltaByte&31)));
			BitBuff|=(Val)<<(sizeof(BitBuff)-y-1);
		} else {
			y+=9;
			BitBuff|=(CurrByte)<<(sizeof(BitBuff)-y-1);
		}
		if (y>=8 && y!=16) {
			x++;
			y-=8;
			out_block[x]=(BitBuff>>8);
			BitBuff=(BitBuff << 8);
		}
		if (y==16) {
			out_block[x+1]=(BitBuff>>8);
			out_block[x+2]=(BitBuff&255);
			x+=2;
			y=0;
			BitBuff=0;
		}
		if (x>=DCL_BLK_SIZE*2) return(-1);
		
	}
	return(x);
}

int comp_delta_decompress(char *prev_block, char *curr_block, char *out_block, int blk_size) {
/*
	int i,y;
	char CurrByte;
	TWO_BYTES BitBuff;

	startval=curr_block[0];
	for (i=1;i<blk_size;i+=2) {
		BitBuff=((curr_block[i]<<8)|(curr_block[i+1]));
				
	}
*/
	return(0);
}
