/*
	Helps create those menu files.

	-- Roy Keene [0230220002019] rkeene@netfueldesign.com
*/

#include "billing.h"
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

extern char *optarg;
extern int optind, opterr, optopt;

void print_help(char *argv0) {
	printf("Usage: %s -f filename -m mode [-k hotkey] [-t type] [-n name]\n\t[-c command] [-T title] [-h]\n\n", argv0);
	printf("  -f\tSelect file to modify\n");
	printf("  -m\tSelect mode {add,delete}\n");
	printf("  -k\tChoose hotkey\n");
	printf("  -t\tChoose type of entry\n");
	printf("  -n\tChoose name of entry\n");
	printf("  -c\tSelect command to execute\n");
	printf("  -T\tSelect title of menu\n");
	printf("  -h\tHelp\n\n");
	return;
}


int main(int argc, char **argv) {
	char arg;
	char title[TITLE_LEN];
	struct menulist menuitem;
	struct menulist readitem;
	struct stat finfo;
	char *file=NULL;
	char mode='a';
	int fd, i, num_ent;
	menuitem.hotkey=0;
	menuitem.exec_cmd.type=255;
	menuitem.name[0]=0;
	menuitem.exec_cmd.exec_file[0]=0;
	title[0]=0;
	while (  (arg=getopt(argc, argv, "hf:k:t:c:m:n:T:"))!=-1  ) {
		switch (arg) {
			case 'f':
				file=optarg;
				break;
			case 'k':
				menuitem.hotkey=toupper(optarg[0]);
				break;
			case 't':
				menuitem.exec_cmd.type=(unsigned char) (atoi(optarg));
				break;
			case 'm':
				mode=tolower(optarg[0]);
				break;
			case 'c':
				strncpy(menuitem.exec_cmd.exec_file,optarg,sizeof(menuitem.exec_cmd.exec_file));
				break;
			case 'n':
				strncpy(menuitem.name, optarg, sizeof(menuitem.name));
				break;
			case 'T':
				strncpy(title, optarg, sizeof(title));
				break;
			default:
				print_help(argv[0]);
				return(-1);
				break;
		}
	}
	if (file==NULL) { 
		printf("Must specify file.\n");
		print_help(argv[0]);
		return(-1);
	}
	if (mode!='a' && mode!='d') {
		printf("Invalid mode.  Must be ADD or DELETE.\n");
		print_help(argv[0]);
		return(-1);
	}
	if (menuitem.hotkey==0) {
		printf("Must specify hotkey.\n");
		print_help(argv[0]);
		return(-1);
	}
	if (mode=='a' && menuitem.exec_cmd.type==255) {
		printf("Must specify type when adding.\n");
		print_help(argv[0]);
		return(-1);
	}
	if (mode=='a' && menuitem.name[0]==0) {
		printf("Must specify menu entry name when adding.\n");
		print_help(argv[0]);
		return(-1);
	}
	if (mode=='a' && menuitem.exec_cmd.exec_file[0]==0) {
		printf("Must specify command file when adding.\n");
		print_help(argv[0]);
		return(-1);
	}
	if ((fd=open(file, O_RDWR|O_CREAT, S_IRUSR|S_IWUSR|S_IRGRP|S_IROTH)) < 0) {
		printf("Cannot open %s for writing, aborting.\n", file);
		perror("menumake: open");
		return(-1);
	}
	fstat(fd, &finfo);
	if (finfo.st_size<TITLE_LEN) {
		if (title[0]==0) {
			close(fd);
			printf("Must specify title for new menu.\n");
			print_help(argv[0]);
			return(-1);
		}
		num_ent=0;
	} else {
		num_ent=(int) ((finfo.st_size-TITLE_LEN)/sizeof(struct menulist));
	}
	if (title[0]==0) {
		read(fd, &title, sizeof(title));
	} else {
		write(fd, &title, sizeof(title));
		lseek(fd, TITLE_LEN, SEEK_SET);
	}
	if (mode=='a') {
		for (i=0;i<num_ent;i++) {
			read(fd, &readitem, sizeof(readitem));
			if (readitem.hotkey==menuitem.hotkey) {
				lseek(fd, -sizeof(menuitem), SEEK_CUR);
				write(fd, &menuitem, sizeof(menuitem));
				close(fd);
				return(0);
			}
		}
		lseek(fd, 0, SEEK_END);
		write(fd, &menuitem, sizeof(menuitem));
	} else {
		/* Need to write the deletion stuff */	
	}
	close(fd);
	return(0);
}
