#include "variable.h"
#include <string.h>
#include <stdlib.h>

char *nameslist[MAX_VAR];
char *valuelist[MAX_VAR];

int setvar(char name[30], char value[]) {
	int i, usei=-1;
	if (name==NULL) return(-1);
	for (i=0;i<MAX_VAR;i++) {
		if (nameslist[i]==NULL) {
			if (usei==-1) usei=i;
		} else {
			if (!strcasecmp(nameslist[i],name)) {
				free(nameslist[i]);
				free(valuelist[i]);
				usei=i;
				break;
			}
		}
	}
	if (usei==-1) return(-1); /* ran out of entries */
	if (value!=NULL) {
		valuelist[usei]=strdup(value);
		nameslist[usei]=strdup(name);
	} else {
		valuelist[usei]=NULL;
		nameslist[usei]=NULL;
	}
	return(0);
}

char *getvar(char name[30]) {
	int i;
	for (i=0;i<MAX_VAR;i++) {
		if (nameslist[i]!=NULL) {
			if (!strcasecmp(nameslist[i],name)) {
				return(valuelist[i]);
			}
		}
	}
	return(NULL);
}

int unsetvar(char name[30]) {
	int i;
	for (i=0;i<MAX_VAR;i++) {
		if (nameslist[i]!=NULL) {
			if (!strcasecmp(nameslist[i],name)) {
				nameslist[i]=NULL;
				valuelist[i]=NULL;
				free(nameslist[i]);
				free(valuelist[i]);
				return(0);
			}
		}
	}
	return(-1);
}
