#include "version.h"
#include "compat.h"
#include "calc.h"
#include "net.h"

extern int optind, optopt, opterr;
extern char *optarg;

static void print_version(void) {
	fprintf(stderr, "MRTG for High Speed interfaces version %s.\n", MRTGHS_VERSION);
	return;
}

static int print_help(int ret) {
	print_version();
	fprintf(stderr, "usage: mrtg-hs [-v] [-f config]\n");
	fprintf(stderr, "  -h         This help.\n");
	fprintf(stderr, "  -v         Increase verbosity.\n");
	fprintf(stderr, "  -f config  Specify a config file.\n");
	return(ret);
}

int main(int argc, char **argv) {
	int verbose=0;
	int retval=0;
	int ch=-1;

	if (net_init()<0) {
		PRINTERR("Network support not available, exiting.");
		return(1);
	}

	while ((ch=getopt(argc, argv, "hvf:"))!=-1) {
		switch (ch) {
			case 'v':
				verbose++;
				break;
			case 'f':
				SPOTVAR_S(optarg);
				break;
			case '?':
			case ':':
			default:
				retval=1;
			case 'h':
				return(print_help(retval));
		}
	}

	return(retval);
}
