/*
	Condensed version of `rm', optimized for space, sortof

	042720000103: TODO: Add support for -[rR] !
	
*/


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "version.h"
#include "rm.h"

extern char *optarg;
extern int optind, opterr, optopt;

int rm_main (int argc, char **argv) {
	unsigned int error_code=0;
	struct stat statbuf;
	char ch;
	char option_dir=0;
	char option_force=0;
	char option_interactive=0;
	char option_recurse=0;
	char option_verbose=0;
	char input_buff[127];
	int i;

	while ((ch=getopt(argc, argv, "dfirvR")) != -1) {
		switch (ch) {
			case 'd':
				option_dir=1;
				break;
			case 'f':
				option_interactive=0;
				option_force=1;
				break;
			case 'i':
				option_force=0;
				option_interactive=1;
				break;
			case 'r':
			case 'R':
				option_recurse=1;
				break;
			case 'v':
				option_verbose=1;
				break;
			default:
				return(-1);
		}
	}

	if (optind==argc) {
		write(STDERR_FILENO, "rm: too few arguments\n",22);
		return(!option_force);
	}

	for (i=optind;i<argc;i++) {
		if (stat(argv[i], &statbuf)<0) {
			if (!option_force) {
				write(STDERR_FILENO, "rm: ", 4);
				perror(argv[i]);
			}
			error_code=1;
			goto loop;
		}
		if (S_ISDIR(statbuf.st_mode) && option_dir==0) {
			if (option_recurse) {

/*  TODO: Add recursion code here */

			}
			write(STDERR_FILENO, "rm: ",4);
			write(STDERR_FILENO, argv[i], strlen(argv[i]));
			write(STDERR_FILENO, " is a directory\n",16);
			error_code=2;
			goto loop;
		}
		if (option_interactive) {
			write(STDOUT_FILENO, "rm: remove `", 12);
			write(STDOUT_FILENO, argv[i], strlen(argv[i]));
			write(STDOUT_FILENO, "\'? ", 3);
			read(STDIN_FILENO, &input_buff, sizeof(input_buff));
			if (input_buff[0]!='y' && input_buff[0]!='Y') goto loop;
		}
		if (option_verbose) 
			write(STDOUT_FILENO,argv[i],strlen(argv[i]));
		if (unlink(argv[i])<0) {
			write(STDERR_FILENO, "rm: ", 4);
			perror(argv[i]);
			error_code=2;
		}
loop:
	}
	return((option_force==0 || error_code>1));
}
