#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <linux/fs.h>
#include <string.h>
#include "version.h"
#include "mount.h"


/* Various declartaions of where to find files. */
#ifndef PROC_FILESYSTEMS
#define PROC_FILESYSTEMS "/proc/filesystems"
#endif
#ifndef ETC_FSTAB
#define ETC_FSTAB "/etc/fstab"
#endif
#ifndef PROC_MOUNTS
#define PROC_MOUNTS "/proc/mounts"
#endif

/* The mount(2) man page was lying to me. */

#if defined(MS_SYNCHRONOUS) && !defined(MS_SYNC)
#define MS_SYNC MS_SYNCHRONOUS
#endif


extern char *optarg;
extern int optind, opterr, optopt;

int mount_main (int argc, char **argv) {
	char *option_fstype=NULL;
	char *fs_source=NULL;
	char *fs_dest=NULL;
	char buf[255];
	char option_fake=0;
	char option_verbose=0;
	char option_fork=0;
	char option_mountall=0;
	char ch;
	int option_options=0;
	int fd;
	int i;

/* Parse our arguments, using getopt(3) ... */

	while ( (ch=getopt(argc,argv,"VafFrvwt:o:")) != -1 ) {
		switch (ch) {
			case 'a':
				option_mountall=1;
/* TODO: Make mountall work. */
				break;
			case 'f':
				option_fake=1;
				break;
			case 'F':
/* TODO: Make fork work, requires -a first.*/
				option_fork=1;
				break;
			case 'r':
				option_options|=MS_RDONLY;
				break;
			case 'v':
/* TODO: Make verbose work. */
				option_verbose=1;
				break;
			case 'w':
				option_options&=(~((int) MS_RDONLY));
				break;
			case 't':
				option_fstype=optarg;
				break;
			case 'o':
				option_options=mount_parse_options(option_options,optarg);
				break;
			case 'V':
				write(STDOUT_FILENO, "mount: mooselinux-" MOOSE_VERSION "\n", 18+sizeof(MOOSE_VERSION));
				return(0);
			default:
				break;
		}
	}

/* If there are no arguments (exluding options), then just display mounts */

	if ((argc-optind)==0) {
		if ((fd=open(PROC_MOUNTS, O_RDONLY))==-1) return(-1);
		while (1) {
			if ((i=read(fd,&buf,sizeof(buf)))==0) break;
			write(STDOUT_FILENO,&buf,i);
		}
		close(fd);
		return(0);		
	}

/* TODO: Add fstab support ! */

/* If there were 2 arguments, mount special arg1 to directory arg2 */

	if ((argc-optind)==2) {
		fs_source=argv[optind];
		fs_dest=argv[optind+1];
	}

/* unless Fake is enabled, then just do nothing. */

	if (!option_fake) {
		if (mount(fs_source,fs_dest,option_fstype,MS_MGC_VAL|option_options,NULL)<0) {
			perror("mount");
			return(-1);
		}
	}

	return(0);
}

/* Parse the mount options */

int mount_parse_options(int initop, char *value) {
	char *buf;

	buf=strtok(value,",");

	while (1) {
		if (!strcmp(buf,"atime"))   initop&=(~((int) MS_NOATIME));
		if (!strcmp(buf,"noatime")) initop|=         MS_NOATIME;
		if (!strcmp(buf,"async"))   initop&=(~((int) MS_SYNC));
		if (!strcmp(buf,"sync"))    initop|=         MS_SYNC;
		if (!strcmp(buf,"dev"))     initop&=(~((int) MS_NODEV));
		if (!strcmp(buf,"nodev"))   initop|=         MS_NODEV;
		if (!strcmp(buf,"exec"))    initop&=(~((int) MS_NOEXEC));
		if (!strcmp(buf,"noexec"))  initop|=         MS_NOEXEC;
		if (!strcmp(buf,"suid"))    initop&=(~((int) MS_NOSUID));
		if (!strcmp(buf,"nosuid"))  initop|=         MS_NOSUID;
		if (!strcmp(buf,"remount")) initop|=         MS_REMOUNT;
		if (!strcmp(buf,"rw"))      initop&=(~((int) MS_RDONLY));
		if (!strcmp(buf,"ro"))      initop|=         MS_RDONLY;
		if (!strcmp(buf,"user"))    initop|=(MS_NODEV | MS_NOSUID | MS_NOEXEC);
		if (!strcmp(buf,"defaults")) initop=0;
		if ((buf=strtok(NULL,","))==NULL) break;
	}

	return(initop);
}
