#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "version.h"
#include "mkfifo.h"

int mkfifo_main (int argc, char **argv) {
	int i;
	int error_code=0;

	if (argc==1) error_code=-1;

	for (i=1;i<argc;i++) {
		if (mknod(argv[i], S_IFIFO|0666, 0)<0) {
			write(STDERR_FILENO, "mkfifo: ", 8);
			perror(argv[i]);
			error_code=-1;
		}
	}
	return(error_code);
}
