/*
	0280420002000: TODO: Add GNU options support.
	0280420002001: TODO: Fix support for the Preserve option (s[ug]id, access time)

*/

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include "version.h"
#include "cp.h"

extern char *optarg;
extern int optind, opterr, optopt;

int cp_main (int argc, char **argv) {
	struct stat statinf;
	struct stat statinf2;
	char *destdir=NULL;
	char buff[4096];
	char read_buff[127];
	char option_force=0;
	char option_try_again=0;
	char option_interactive=0;
	char option_preserve=0;
	char option_recurse=0;
	char ch;
	int in_fd=-1, out_fd=-1;
	int i,x;
	int error_code=0;

	while ( (ch=getopt(argc,argv,"fipRr")) != -1) {
		switch (ch) {
			case 'f':
				option_force=1;
				break;
			case 'i':
				option_interactive=1;
				break;
			case 'p':

				option_preserve=1;
				break;
			case 'R':
			case 'r':
/* TODO: Make recursive copying work. */
				option_recurse=1;
				break;
			default:
		}
	}

	if ((argc-optind)<2) {
		write(STDERR_FILENO, "cp: missing file argument\n", 26);
		return(-1);
	}

	statinf.st_mode=0;
	stat(argv[argc-1], &statinf);
	if (S_ISDIR(statinf.st_mode)) { 
		destdir=argv[argc-1];
	} else {
		if ((argc-optind)!=2) {
			write(STDERR_FILENO, "cp: when copying multiple files, last argument must be a directory\n", 67);
			return(-1);
		}
	}

	for (i=optind;i<argc-1;i++) {
		if (destdir==NULL) {
			strncpy(buff,argv[argc-1],sizeof(buff)-1);
		} else {
			sprintf(buff, "%s/%s", destdir, argv[i]);
		}

		if (option_interactive) {
			if (!access(buff,F_OK)) {
				write(STDERR_FILENO, "cp: overwrite `", 15);
				write(STDERR_FILENO, buff, strlen(buff));
				write(STDERR_FILENO, "'? ", 3);
				read(STDIN_FILENO, &read_buff, sizeof(read_buff));
				if (read_buff[0]!='Y' && read_buff[0]!='y') goto loop;
			}
		}

		stat(argv[i], &statinf);
		stat(buff, &statinf2);
		if (statinf.st_ino==statinf2.st_ino) {
			write(STDERR_FILENO, "cp: `", 5);
			write(STDERR_FILENO, argv[i], strlen(argv[i]));
			write(STDERR_FILENO, "' and `", 7);
			write(STDERR_FILENO, buff, strlen(buff));
			write(STDERR_FILENO, "' are the same file\n", 20);
			error_code=-1;
			goto loop;
		}

top:
		if ((out_fd=open(buff, O_WRONLY|O_CREAT|O_TRUNC, statinf.st_mode))<0) {
			if (option_force && option_try_again==0) {
				option_try_again=1;
				unlink(buff);
				goto top;
			}
			option_try_again=0;
			write(STDERR_FILENO, "cp: ", 4);
			perror(buff);
			error_code=-1;
			goto loop;
		}
		if (option_preserve) {
			fchown(out_fd, statinf.st_uid, statinf.st_gid);
		}
		if ((in_fd=open(argv[i], O_RDONLY))<0) {
			write(STDERR_FILENO, "cp: ", 4);
			perror(argv[i]);
			close(out_fd);
			goto loop;
		}
		while (1) {
			if ((x=read(in_fd, &buff, sizeof(buff)))<1) break;
			write(out_fd, &buff, x);
		}
		close(in_fd);
		close(out_fd);
		out_fd=-1;
loop:
	}


	return(error_code);
}
