#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "version.h"
#include "cat.h"

int cat_main (int argc, char **argv) {
	char buf[1024];
	int error_code=0;
	int i,x;
	int fd=-1;

/* If no input files are given on the command line, use STDIN instead. */
	if (argc==1) {
		fd=STDIN_FILENO;
		argc++;
	}


/* Loop through files given on the command line*/

	for (i=1;i<argc;i++) {
/* Make sure we're not supposed to be reading STDIN */
		if (fd==-1) {
/* If there is an error, print it and continue loop */
			if ((fd=open(argv[i],O_RDONLY))<0) {
				write(STDERR_FILENO, "cat: ", 5);
				perror(argv[i]);
				error_code=-1;
				goto loop;
			}
		}
/* Read the file in 1024 byte sections until we encounter the end. */
		while (1) {
			if ((x=read(fd, &buf, 1024))<1) break;
			write(STDOUT_FILENO, &buf, x);
		}
		close(fd);
loop:		
	}

/* If there were any errors, exit in error. */

	return(error_code);
}
