#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/mount.h>
#include <linux/fs.h>
#include "version.h"
#include "umount.h"

extern char *optarg;
extern int optind, opterr, optopt;

int umount_main (int argc, char **argv) {
	char *option_fstype=NULL;
	char option_umountall=0;
	char option_verbose=0;
	char ch;

        while ( (ch=getopt(argc,argv,"VafFrvwt:o:")) != -1 ) {
                switch (ch) {
			case 'a':
/* TODO: Make the umountall option work */
				option_umountall=1;
				break;
			case 'v':
/* TODO: Make the Verbose option work */
				option_verbose=1;
				break;
			case 't':
/* TODO: Make the fstype option work, depends on umountall option*/

				option_fstype=optarg;
				break;
			case 'V':
				write(STDOUT_FILENO, "umount: mooselinux-" MOOSE_VERSION "\n", 19+sizeof(MOOSE_VERSION));
				return(0);
			default:
				return(-1);
 		}
	}

	if ((argc-optind)==0) {
		return(-1);
	}


	if (umount(argv[optind])<0) {
		perror("umount");
	}
	return(0);
}
