#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <string.h>
#include <sys/wait.h>
#include "version.h"
#include "sh.h"

extern char *optarg;
extern char **environ;
extern int optind, opterr, optopt;

int sh_main (int argc, char **argv) {
	char *buff;
	char ch;
	int infrom=STDIN_FILENO;
	int i=0,x;

	while ( (ch=getopt(argc,argv,"isc:-")) != -1) {
		switch (ch) {
			case 'c':
				if ((infrom=open(optarg,O_RDONLY))<0) {
					perror("sh");
					return(-1);
				}
			case 's':
			case 'i':
			case '-':
			default:
				return(-1);
		}
	}
	
	buff=calloc(4096, 1);
/* TODO: Make Environment variable PS1 supported */
	write(STDOUT_FILENO, "shell# ", 7);
	while (1) {
		if (read(infrom, &ch, 1)<1) break;
		if (ch==13 || ch==10) {
			x=strlen(buff);
			if (buff[x-1]=='\\') {
				i--;
				buff[x-1]=' ';
/* TODO: Make Environment variable PS2 supported */
				write(STDOUT_FILENO, "> ", 2);
				goto loop;
			}
			sh_process_command(buff);
			free(buff);
			buff=calloc(4096, 1);
			i=0;
			write(STDOUT_FILENO, "shell# ", 7);
			goto loop;
		}
		buff[i++]=ch;
loop:
	}
	return(0);
}

int sh_process_command (char *value) {
	char *argv[128];
	char valuecp[1024];
	int i=0,x;
	int status, retval=0;

	strncpy(valuecp, value, sizeof(valuecp));

	argv[i]=strtok(value, " ");
	while (1) {
		if (argv[i]==NULL) break;
		argv[++i]=strtok(NULL, " ");
	}

	if (argv[0]==NULL) return(0);

	if (!strcmp(argv[0],"exit")) { 
		if (argv[1]==NULL) { exit(0); } else { exit(atoi(argv[1])); }
	}
	if (!strcmp(argv[0],"cd")) {
		if (chdir(argv[1])<0) {
			write(STDERR_FILENO, "sh: ", 4);
			perror("cd");
		}
		return(0);
	}


	if ((x=fork())!=0) { 
		waitpid(x,&status,0);
		if (WIFEXITED(status)) retval=WEXITSTATUS(status);
		if (retval) {
			printf("[%i]+  %-15i %s\n",x,retval,valuecp);
		}
		return(retval); 
	}

	if (execvp(argv[0], argv)<0) {
		write(STDERR_FILENO, "sh: ", 5);
		perror(argv[0]);
	}
	exit(127);
}
