#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include "version.h"
#include "mknod.h"

int mknod_main (int argc, char **argv) {
	int major=0, minor=0, dev=S_IFREG;

	if (argc==3) {
		if (strcmp(argv[2],"p")) return(mknod_argerror());
	} else {
		if (argc==5) {
			major=atoi(argv[3]);
			minor=atoi(argv[4]);
		} else {
			return(mknod_argerror());
		}
	}

	switch (argv[2][0]) {
		case 'p':
			dev=S_IFIFO;
			break;
		case 'b':
			dev=S_IFBLK;
			break;
		case 'u':
		case 'c':
			dev=S_IFCHR;
			break;
		default:
			return(mknod_argerror());
			break;
	}

	if (mknod(argv[1], 0666 | dev, (major<<8)+minor)<0) {
		write(STDERR_FILENO, "mknod: ", 7);
		perror(argv[1]);
	}
	return(0);
}

int mknod_argerror(void) {
	write(STDERR_FILENO, "mknod: insuffcient arguments\n", 29);
	return(-1);
}
