#!/bin/sh

TODOFILE=minidist.txt

if [ "$1" = "" ]; then
	OPT="-e @"
fi

while [ "$1" != "" ]; do
	case "$1" in 
		-p)
			OPT="$OPT -e %"
			;;
		-t)
			OPT="$OPT -e @"
			;;
		-i)
			OPT="$OPT -e \^"
			;;
		-f)
			OPT="$OPT -e #"
			;;
		-h)
			echo "Usage:"
			echo "$0 [-p] [-t] [-f] [-h]"
			echo -e "  -p\tDisplay paritally completed commands"
			echo -e "  -t\tDisplay unstarted commands"
			echo -e "  -f\tDisplay fully completed commands"
			echo -e "  -i\tDisplay started but dsyfunctional commands"
			echo -e "  -h\tDisplay this help screen"
			exit
			;;
	esac
	shift
done
if [ "$OPT" = "" ]; then
	exit
fi
grep -v "\!" $TODOFILE | grep $OPT | cut -c 2-1000
