#!/bin/bash

G_VERS="`grep '^# *define *.*VERSION ' version.h src/version.h *.h src/*.h 2>/dev/null | grep -v '^config.*\.h:' | head -1 | sed -e s/'^.* '//g -e s/'"'//g`"
if [ -f makearch.info ]; then
	source makearch.info
elif [ -f build/makearch.info ]; then
	source build/makearch.info
else
	echo "Error: No \"makearch.info\" file found." >&2
	exit 1
fi
DATE_VAL="`date`"

if [ -z "${VERS}" ]; then
	VERS="${G_VERS}"
fi
if [ -z "${UTIL}" ]; then
	echo "Error: Unable to determine utility name, aborting." >&2
	exit 1
fi
if [ -z "${VERS}" ]; then
	echo "Error: Unable to determine version number, aborting." >&2
	exit 1
fi
if echo ${UTIL} | egrep '(/|-)'  2>/dev/null >/dev/null; then
	echo "Error: Utility name has a dash (-) or slash (/) in it." >&2
	exit 1
fi

export VERS UTIL

TMPDIR="../${UTIL}-${VERS}"
if mkdir "${TMPDIR}"; then
	true
else
	TMPDIR="/tmp/${UTIL}-${VERS}"
	mkdir "${TMPDIR}" || exit 1
fi
cp -a * "${TMPDIR}" 2>/dev/null >/dev/null
cd "${TMPDIR}" || exit 1
rm -f makearch.info .* 2>/dev/null >/dev/null
find . -name 'CVS' -type d -exec rm -rf {} \; >/dev/null 2>/dev/null

if [ ! -z "${BEFORE}" -a -x "${BEFORE}" ]; then
	if "${BEFORE}" 2>/dev/null >/dev/null; then
		rm -f "${BEFORE}" 2>/dev/null >/dev/null
	else
		echo "Error: BEFORE script failed." >&2
		exit 1
	fi
fi

make mrproper 2>/dev/null >/dev/null
make clean 2>/dev/null >/dev/null
make distclean 2>/dev/null >/dev/null
./configure 2>/dev/null >/dev/null
make 2>/dev/null >/dev/null
for file in ${BINS}; do
	if [ ! -x ${file} ]; then
		echo "Sanity check: building \"${file}\" failed." >&2
		exit=true
	fi
done
for file in ${REQS}; do
	if [ ! -f ${file} ]; then
		echo "Sanity check: required file \"${file}\" failed." >&2
		exit=true
	fi
done
for file in ${DOC_HDR} ${DOCS}; do
	if [ -f "${file}" ]; then
		TMPFILE="/tmp/sed$$`date +%H%M%S`${RANDOM}"
		rm -f ${TMPFILE} 2>/dev/null >/dev/null
		sed -e s/'@@VERS@@'/"${VERS}"/g -e s/'@@UTIL@@'/"${UTIL}"/g -e s/'@@DATE@@'/"${DATE_VAL}"/g ${file} > ${TMPFILE}
		if [ ! "${file}" = "${DOC_HDR}" -a -f "${DOC_HDR}" ]; then
			cat ${DOC_HDR} > ${file}
		else
			echo -n > ${file}
		fi
		cat ${TMPFILE} >> ${file}
		rm -f ${TMPFILE} 2>/dev/null >/dev/null
	fi
done
if [ ! -z "${AFTER}" -a -x "${AFTER}" ]; then
	if "${AFTER}" 2>/dev/null >/dev/null; then
		rm -f "${AFTER}" 2>/dev/null >/dev/null
	else
		echo "Error: AFTER script failed." >&2
		exit=true
	fi
fi
for file in ${TMPS}; do
	if echo ${file} | grep '/' 2>/dev/null >/dev/null; then
		echo "Error: TMPS list contains a slash (/)" >&2
		exit=true
		break
	fi
	if [ -d "${file}" ]; then
		rm -rf "${file}" 2>/dev/null >/dev/null
	else
		rm -f ${file} 2>/dev/null >/dev/null
	fi
done
if [ ! -z "${exit}" ]; then
	cd ../
	rm -rf ${UTIL}-${VERS}/ 2>/dev/null >/dev/null
	exit 1
fi


make clean 2>/dev/null >/dev/null
make depend 2>/dev/null >/dev/null
make Makefile.dep 2>/dev/null >/dev/null
make distclean 2>/dev/null >/dev/null
rm -f MD5SUMS 2>/dev/null >/dev/null
find . -type f -print 2>/dev/null | sed s/'^\.\/'/''/ | xargs md5sum >> MD5SUMS 2>/dev/null

cd ../
echo "Creating ${UTIL}-${VERS}.tar.gz..."
tar -zcvf ${UTIL}-${VERS}.tar.gz ${UTIL}-${VERS}/
rm -rf ${UTIL}-${VERS}/ 2>/dev/null >/dev/null
if [ -d archive ]; then
	mkdir -p archive/${UTIL}/ 2>/dev/null
	mv ${UTIL}-${VERS}.tar.gz archive/${UTIL}/ 2>/dev/null >/dev/null
	for file in archive/${UTIL}-*.tar.gz; do
		if [ -L "${file}" ]; then rm -f ${file} 2>/dev/null; fi
	done
	ln -s ${UTIL}/${UTIL}-${VERS}.tar.gz archive/${UTIL}-${VERS}.tar.gz 2>/dev/null >/dev/null
fi
