/*
 * Copyright (C) 2001, 2002, and 2003  Roy Keene
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *      email: libopennet@rkeene.org
 */

#ifndef _OPENNET_H 
#define _OPENNET_H
#include <sys/types.h>
#include <unistd.h>
#include <stdio.h>


#ifdef  __cplusplus
extern "C" {
#endif

typedef struct {
	int fd;
	char *buf;
	char *buf_s;
	unsigned long bufsize;
	unsigned long bufsize_s;
	unsigned long bufused;
	int eof;
	int socket;
	off_t pos;
	off_t length;
	char *url;
} NETFILE;


/* Open a URL.  Same syntax as POSIX open(), except `mode' is required. */
int open_net(const char *pathname, int flags, mode_t mode);

/* Seek in a file or stream.  Same syntax as POSIX lseek(). */
off_t lseek_net(int filedes, off_t offset, int whence);

/* A more deterministic POSIX read(). */
ssize_t read_net(int fd, void *buf, size_t count);

/* ANSI fopen() clone. */
NETFILE *fopen_net(const char *path, const char *mode);

/* ANSI fgets() clone */
char *fgets_net(char *s, int size, NETFILE *stream);

/* ANSI feof() clone */
int feof_net(NETFILE *stream);

/* ANSI fread() clone */
size_t fread_net(void *ptr, size_t size, size_t nmemb, NETFILE *stream);

/* ANSI fseek() clone. */
int fseek_net(NETFILE *stream, long offset, int whence);

/* ANSI ftell() clone. */
long ftell_net(NETFILE *stream);

/* ANSI fclose() clone */
int fclose_net(NETFILE *stream);

/* ANSI fseeko() clone */
int fseeko_net(NETFILE *stream, off_t offset, int whence);

/* ANSI ftello() clone */
off_t ftello_net(NETFILE *stream);

/* ANSI setvbuf() clone */
int setvbuf_net(NETFILE *stream, char *buf, int mode, size_t size);

/* Return the length of a stream, if possible. ((off_t) -1) if not available */
off_t flength_net(NETFILE *stream);

#ifdef  __cplusplus
}
#endif

#endif
